/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.utils;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.tika.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSalvager {
    private static final Logger LOG = LoggerFactory.getLogger(ZipSalvager.class);

    public static void salvageCopy(InputStream brokenZip, File salvagedZip) {
        try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(salvagedZip);){
            ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream(brokenZip);
            ZipArchiveEntry zae = zipArchiveInputStream.getNextZipEntry();
            while (zae != null) {
                try {
                    if (!zae.isDirectory() && zipArchiveInputStream.canReadEntryData(zae)) {
                        outputStream.putArchiveEntry(new ZipArchiveEntry(zae.getName()));
                        boolean successfullyCopied = false;
                        try {
                            IOUtils.copy((InputStream)zipArchiveInputStream, (OutputStream)outputStream);
                            successfullyCopied = true;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        outputStream.flush();
                        outputStream.closeArchiveEntry();
                        if (!successfullyCopied) break;
                    }
                    zae = zipArchiveInputStream.getNextZipEntry();
                }
                catch (EOFException | ZipException e) {
                    // empty catch block
                    break;
                }
            }
            outputStream.flush();
            outputStream.finish();
        }
        catch (IOException e) {
            LOG.warn("problem fixing zip", e);
        }
    }

    public static void salvageCopy(File brokenZip, File salvagedZip) throws IOException {
        try (InputStream is = Files.newInputStream(brokenZip.toPath(), new OpenOption[0]);){
            ZipSalvager.salvageCopy(is, salvagedZip);
        }
    }
}

