/*
 *
 *	File: Reader.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font.postscript;

import java.io.IOException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.FontInputStream;

/**
 * An interface used to hide the current encryption of a type1 font from the
 * Tokenizer class.
 */
public interface Reader {
    /**
     * Read the next byte from the input stream.
     * @param stream
     * @return the byte read or -1 if EOF
     * @throws IOException Propogated from stream.read 
     * @throws InvalidFontException Thrown if EOF is hit.
     */
    int read(FontInputStream stream)
    	throws IOException, InvalidFontException;
    void unreadLast(FontInputStream stream)
    	throws IOException;
}