/**
 * 
 */
package com.adobe.internal.io;

import java.io.RandomAccessFile;

/**
 * An implementation of the ByteReader interface that provides access to a
 * RandomAccessFile.  This implementation uses buffering to limit
 * the number of calls to the methods of the {@link java.io.RandomAccessFile RandomAccessFile}
 * class.  This is because such methods use JNI and any calls to native code from Java
 * are very slow.
 * 
 * This class is <b>not</b> threadsafe.  It is not safe to pass an instance of this class
 * to multiple threads.  It is not safe to pass an instance of this class to multiple users even
 * if in the same thread.  It is not safe to give the same RandomAccessFile to multiple instances
 * of this class.
 */
public class RandomAccessFileByteReader extends ByteReaderWrapperImpl
{
	/**
	 * Constructor.
	 * @param file the file to wrap.
	 */
	public RandomAccessFileByteReader(RandomAccessFile file)
    {
		super(new RandomAccessFileByteWriter(file));
    }
}
