/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.localeset;

import com.adobe.xfa.ChildReln;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Node;
import com.adobe.xfa.Schema;
import com.adobe.xfa.XFA;

/**
 * This holds the LocaleSet schema definitions. 
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public final class LocaleSetSchema extends Schema {

	static final ChildReln goZeroOr2 = new ChildReln(ChildReln.zeroOrMore, 2);
	static final ChildReln goZeroOr3 = new ChildReln(ChildReln.zeroOrMore, 3);
	static final ChildReln goZeroOr4 = new ChildReln(ChildReln.zeroOrMore, 4);
	static final ChildReln goZeroOr5 = new ChildReln(ChildReln.zeroOrMore, 5);
	static final ChildReln goZeroOr7 = new ChildReln(ChildReln.zeroOrMore, 7);
	static final ChildReln goZeroOr12 = new ChildReln(ChildReln.zeroOrMore, 12);


	LocaleSetSchema() {
		super(LocaleSetModel.localeSetNS(),
				XFA.XFA_ATTRIBUTE_MIN, 
				XFA.XFA_ATTRIBUTE_MAX, 
				XFA.XFA_ELEMENT_MIN, 
				XFA.XFA_ELEMENT_MAX);
		initSchema();
	}


	/**
	 * Initialize the localeSet schema.
	 * <p>
	 * To add an Attribute to the LocaleSetSchema, follow these steps:<br/>
	 *  1. Add the attribute name as a namespace in xfanamespace.h+cpp<br/>
	 *  2. Add the attribute to 'mAttrNames', and up the value of
	 *     XFA_TEMPLATE_ATTR_COUNT by one<br/>
	 *  3. Add the attribute will a default value to mAttributes<br/>
	 *  4. For each element that this attribute will apply to, add it's name
	 *     to the attribute list for this element schema definition (the 
	 *     attribute list definition used in the putSchema(element) call)<br/>
	 * 
	 */

	protected void initSchema() {
		// Get a TLS for the enums.
		super.initSchema();

		// Don't add TextNode since it is not an Element
		//addSample(XFA.TEXTNODETAG, "com.adobe.xfa.TextNode", true);

		//
		// populate the schema relationships
		//

		// localeSet
		putElement(XFA.LOCALESETTAG, XFA.LOCALETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// locale
		putAttribute(XFA.LOCALETAG, XFA.NAMETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putAttribute(XFA.LOCALETAG, XFA.DESCTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.LOCALETAG, XFA.CALENDARSYMBOLSTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.LOCALETAG, XFA.DATEPATTERNSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.LOCALETAG, XFA.TIMEPATTERNSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.LOCALETAG, XFA.DATETIMESYMBOLSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.LOCALETAG, XFA.NUMBERPATTERNSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.LOCALETAG, XFA.NUMBERSYMBOLSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.LOCALETAG, XFA.CURRENCYSYMBOLSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003 
		putElement(XFA.LOCALETAG, XFA.TYPEFACESTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_27, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL344982 Nov 7, 2006 //Watson 1442022 - keep typefaces out until a later version

		// calendarSymbols
		putAttribute(XFA.CALENDARSYMBOLSTAG, XFA.NAMETAG, EnumValue.getEnum(XFA.NAMETAG, EnumAttr.getEnum(EnumAttr.CALENDAR)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.CALENDARSYMBOLSTAG, XFA.DAYNAMESTAG, goZeroOr2, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.CALENDARSYMBOLSTAG, XFA.MONTHNAMESTAG, goZeroOr2, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.CALENDARSYMBOLSTAG, XFA.ERANAMESTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.CALENDARSYMBOLSTAG, XFA.MERIDIEMNAMESTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// dayNames
		putAttribute(XFA.DAYNAMESTAG, XFA.ABBRTAG, EnumValue.getEnum(XFA.ABBRTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.DAYNAMESTAG, XFA.DAYTAG, goZeroOr7, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// day
		putElement(XFA.DAYTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// monthNames
		putAttribute(XFA.MONTHNAMESTAG, XFA.ABBRTAG, EnumValue.getEnum(XFA.ABBRTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.MONTHNAMESTAG, XFA.MONTHTAG, goZeroOr12, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// month
		putElement(XFA.MONTHTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// eraNames
		putElement(XFA.ERANAMESTAG, XFA.ERATAG, goZeroOr2, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// era
		putElement(XFA.ERATAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// meridiemNames
		putElement(XFA.MERIDIEMNAMESTAG, XFA.MERIDIEMTAG, goZeroOr2, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// meridiem
		putElement(XFA.MERIDIEMTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// datePatterns
		putElement(XFA.DATEPATTERNSTAG, XFA.DATEPATTERNTAG, goZeroOr4, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// datePattern
		putAttribute(XFA.DATEPATTERNTAG, XFA.NAMETAG, EnumValue.getEnum(XFA.NAMETAG, EnumAttr.getEnum(EnumAttr.PATTERN_FULL)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.DATEPATTERNTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// timePatterns
		putElement(XFA.TIMEPATTERNSTAG, XFA.TIMEPATTERNTAG, goZeroOr4, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// timePattern
		putAttribute(XFA.TIMEPATTERNTAG, XFA.NAMETAG, EnumValue.getEnum(XFA.NAMETAG, EnumAttr.getEnum(EnumAttr.PATTERN_FULL)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.TIMEPATTERNTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// dateTimeSymbols
		putElement(XFA.DATETIMESYMBOLSTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003


		// numberPatterns
		putElement(XFA.NUMBERPATTERNSTAG, XFA.NUMBERPATTERNTAG, goZeroOr3, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// numberPattern
		putAttribute(XFA.NUMBERPATTERNTAG, XFA.NAMETAG, EnumValue.getEnum(XFA.NAMETAG, EnumAttr.getEnum(EnumAttr.PATTERN_NUMERIC)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.NUMBERPATTERNTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// numberSymbols
		putElement(XFA.NUMBERSYMBOLSTAG, XFA.NUMBERSYMBOLTAG, goZeroOr5, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// numberSymbol
		putAttribute(XFA.NUMBERSYMBOLTAG, XFA.NAMETAG, EnumValue.getEnum(XFA.NAMETAG, EnumAttr.getEnum(EnumAttr.NUMERIC_DECIMAL)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.NUMBERSYMBOLTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// currencySymbols
		putElement(XFA.CURRENCYSYMBOLSTAG, XFA.CURRENCYSYMBOLTAG, goZeroOr3, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// currencySymbol
		putAttribute(XFA.CURRENCYSYMBOLTAG, XFA.NAMETAG, EnumValue.getEnum(XFA.NAMETAG, EnumAttr.getEnum(EnumAttr.CURRENCY_SYMBOL)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003
		putElement(XFA.CURRENCYSYMBOLTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL57097 Jun 3, 2003

		// typefaces
		//Watson 1442022 - keep typefaces out until a later version
		putElement(XFA.TYPEFACESTAG, XFA.TYPEFACETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_27, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL344982 Nov 7, 2006

		// typeface
		putAttribute(XFA.TYPEFACETAG, XFA.NAMETAG, null, Schema.XFAVERSION_27, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL344982 Nov 7, 2006
	}
	

	protected Element newElement(int eTag, Element parent, Node prevSibling) {
		
		switch (eTag) {
		
		// TextNode is not an Element!
		//case XFA.TEXTNODETAG:
		
		case XFA.LOCALESETTAG: return new com.adobe.xfa.localeset.LocaleSetModel(parent, prevSibling);
		
		case XFA.LOCALETAG:
		case XFA.CALENDARSYMBOLSTAG:
		case XFA.DAYNAMESTAG:
		case XFA.DAYTAG:
		case XFA.MONTHNAMESTAG:
		case XFA.ERANAMESTAG:
		case XFA.MERIDIEMNAMESTAG:
		case XFA.DATEPATTERNSTAG:
		case XFA.TIMEPATTERNSTAG:
		case XFA.NUMBERPATTERNSTAG:
		case XFA.NUMBERSYMBOLSTAG:
		case XFA.CURRENCYSYMBOLSTAG:
		case XFA.TYPEFACESTAG:
		case XFA.TYPEFACETAG:
			return new com.adobe.xfa.GenericNode(parent, prevSibling);
			
		case XFA.MONTHTAG:
		case XFA.ERATAG:
		case XFA.MERIDIEMTAG:
		case XFA.DATEPATTERNTAG:
		case XFA.TIMEPATTERNTAG:
		case XFA.DATETIMESYMBOLSTAG:
		case XFA.NUMBERPATTERNTAG:
		case XFA.NUMBERSYMBOLTAG:
		case XFA.CURRENCYSYMBOLTAG:
			return new com.adobe.xfa.GenericTextContainer(parent, prevSibling);
			
		default:
			return null;
		}
	}
	
}
