package com.adobe.xfa.text.markup;

import org.xml.sax.Attributes;

/**
 * @exclude from published api.
 */

abstract class XMLParserBase {
	public void processText (String sText) {
		XMLParserImpl oImpl = new XMLParserImpl (this);
		oImpl.processText (sText);
	}

	abstract public void onStartTag (String name, Attributes attributes);
	abstract public void onEndTag (String name);
	abstract public void onContent (String content);
}

/**
 * @exclude from published api.
 */

public abstract class XMLParser extends XMLParserBase {
	public void onStartTag (String name, Attributes attributes) {
		onStartTag (name);
		int size = attributes.getLength();
		for (int i = 0; i < size; i++) {
			String attrName = attributes.getLocalName (i);
			String attrValue = attributes.getValue (i);
			onAttribute (attrName, attrValue);
		}
		
	}
	abstract public void onStartTag (String name);
	abstract public void onAttribute (String name, String value);
}
