// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model;

import java.io.Serializable;



/**
 * The base interface for all XMP property types, which are
 * <ul>
 * 		<li><code>SimpleType</code> (describes simple properties),
 * 		<li><code>ArrayType</code> (describes array properties),
 * 		<li><code>StructType</code> (describes struct properties),
 * 		<li><code>UnspecifiedType</code> (this is only used during schema parsing)
 * </ul>
 * 
 * @author Stefan Makswit
 */
public interface PropertyType extends Serializable
{
	/**
	 * The name of the property type is optional. It is only used to register it
	 * in the <code>TypeRegistry</code> so that it can be re-used. Names are
	 * also used to point to the core XMP types, that are defined in the
	 * specifications and are available as include files for RelaxNG.
	 * 
	 * @return Returns the name of the type.
	 */
	String getName();


	/**
	 * @param name the type name to set.
	 */
	abstract void setName(String name);


	/**
	 * @return Returns the default label of the property type in English.
	 */
	String getLabel();


	/**
	 * @param label
	 *            the default label to set
	 */
	void setLabel(String label);


	/**
	 * @return Returns the default description of the property type in English.
	 */
	String getDescription();


	/**
	 * @param description
	 *            the default description to set
	 */
	void setDescription(String description);
	
	
	/**
	 * @return Returns the rule that constrain this array.
	 * This rule can be the root of a logic tree.
	 */
	TypeRule getRule();
	
	
	/** 
	 * Add the root rule of a logic tree.
	 * There are restrictions on the rules allowed depending on the data type.
	 * @param rule the rule to add
	 */
	void setRule(TypeRule rule);
	
	
	/**
	 * @param schemaVisitor a visitor that implements the <code>SchemaVisitor</code>-interface
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void accept(SchemaVisitor schemaVisitor) throws XMPSchemaException;
}
