/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2006 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.commons.datasource.poolservice;

/**
 * Used by DataSourcePool to provide data sources of
 * a single type (for example a JDBC DataSource or an
 * LDAPDataSource).
 */
public interface DataSourcePoolProvider {
    /**
     * Return the named data source, if available
     *
     * @param name Configured name of the data source
     * @return a data source Object, null if not found
     */
    Object getDataSource(String name);

    /**
     * Returns the names of data sources
     * @return the names
     */
    String[] getNames();
}
