/**
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.day.cq.wcm.foundation.model.responsivegrid;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Represents a responsive breakpoint. A breakpoint contains all the responsive properties for a given resource.
 */
@ProviderType
public class Breakpoint {

    private String name;
    private int width;
    private int offset;
    private ResponsiveBehavior behavior;

    /**
     * Responsive behavior to be applied on a component for the current breakpoint.
     */
    enum ResponsiveBehavior {
        /**
         * Reset or ensure no behavior is applied for the current breakpoint.
         */
        none,
        /**
         * The resource should go to the next line.
         */
        newline,
        /**
         * The resource should be hidden.
         */
        hide
    }

    public Breakpoint(String name, int width, int offset, ResponsiveBehavior behavior) {
        this.name = name;
        this.width = width;
        this.offset = offset;
        this.behavior = behavior;
    }

    /**
     * @return The name of the breakpoint.
     */
    public String getName() {
        return name;
    }

    /**
     * @return The width (in number of columns) of the breakpoint.
     */
    public int getWidth() {
        return width;
    }


    /**
     * @return The offset (in number of columns) before the component.
     */
    public int getOffset() {
        return offset;
    }

    /**
     * @return The {@link ResponsiveBehavior} of the breakpoint.
     */
    public ResponsiveBehavior getResponsiveBehavior() {
        return behavior;
    }

}

