/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.msm.api;

import org.apache.sling.api.resource.Resource;

import com.day.cq.wcm.api.WCMException;

/**
 * An Factory used to create LiveActions.
 * Used to register LiveAction implementations with the ServiceComponentRegistration
 * It enables to create LiveActions with a Configuration given by a Resource
 * 
 * @param <Type>
 * @see LiveAction
 */
public interface LiveActionFactory<Type extends LiveAction> {

    /**
     * The Service Registration Property reporting the name of
     * LiveActions this factory can create
     */
    String LIVE_ACTION_NAME = "liveActionName";

    /**
     * @return name of the LiveAction to create. It must match
     * {@link com.day.cq.wcm.msm.api.LiveAction#getName() getName() of LiveAction}
     * @see LiveAction#getName(); 
     */
    String createsAction();

    /**
     * @param resource containing configuration values
     * @return the action instance or <code>null</code>
    , if given resource does not suited to created an Action
     * @throws WCMException in case of error
     */
    Type createAction(Resource resource) throws WCMException;
}
