/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.webservicesupport;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

import aQute.bnd.annotation.ProviderType;

import com.day.cq.wcm.api.Template;

/**
 * Represents a web service entry in context of web service configurations. A
 * {@link Service} acts mainly as container for {@link Configuration} entries.
 * 
 * @since 5.5
 */
@ProviderType
public interface Service {
    
    /**
     * Base path for service {@link Resource}s.
     */
    static final String BASE_PATH = "/etc/cloudservices";
    
    /**
     * Return the jcr:title property of the service.
     * 
     * @return String representation of title
     */
    String getTitle();
    
    /**
     * Returns an Long value of the includsionRank property.
     * 
     * @return Long value of rank
     */
    Long getInclusionRank();
    
    /**
     * Return jcr:description property of the service.
     * 
     * @return String representation description
     */
    String getDescription();
    
    /**
     * Returns the name of the service. This is the first segment of the
     * configuration path after the base path.
     * 
     * @return String representation of name
     */
    String getName();
    
    /**
     * Returns the path of the service.
     * 
     * @return String of service path or <code>null</code>
     */
    String getPath();
    
    /**
     * Returns a path to a related page component or <code>null</code> if not
     * defined.
     * 
     * @return String of a path or <code>null</code>
     */
    String getComponentReference();
    
    /**
     * Returns the URL to the service or <code>null</code> if not defined.
     * 
     * @return String of an URL or <code>null</code>
     */
    String getServiceUrl();
    
    /**
     * Returns the URL label for the service URL link or <code>null</code> if not defined.
     * @return String of a URL label or <code>null</code>
     */
    String getServiceUrlLabel();
    
    /**
     * Returns the path to an icon for this service or <code>null</code> if
     * this service does not provide an icon.
     *
     * @return String of a path to an icon or <code>null</code>
     */
    String getIconPath();    
    
    /**
     * Returns the path to a thumbnail for this service or <code>null</code> if
     * this service does not provide a thumbnail.
     *
     * @return String of a path to an icon or <code>null</code>
     */
    String getThumbnailPath();
    
    /**
     * Returns the pages {@link Template} or <code>null</code> if no template has
     * been found or the current user does not have read access to the 
     * template resource specified by the path in the page's template property. 
     * This is the case on publish instances using default ACL configuration 
     * (anonymous cannot read templates).
     * 
     * @return Page {@link Template} or <code>null</code>
     */
    Template getTemplate();
    
    /**
     * Returns the service {@link Resource}.
     * 
     * @return {@link Resource} or <code>null</code>
     */
    Resource getResource();
    
    /**
     * Returns the {@link Resource} of the services content or <code>null</code>
     * if the service has no content.
     * 
     * @return Content {@link Resource} or <code>null</code>
     */
    Resource getContentResource();
    
    /**
     * Returns a value map of the service content. If the service has no content
     * an empty map is returned.
     * 
     * @return A {@link ValueMap} or {@link ValueMap#EMPTY}
     */
    ValueMap getProperties();

    /**
     * Returns an array of paths to selectable child templates.
     * 
     * @return A String array of selectable template paths
     */
    String[] getSelectableChildren();
    
    /**
     * Checks if provided template path is selectable.
     * 
     * @param templatePath templatePath
     * @return <code>true</code> if <code>templatePath</code> is selectable,
     *         <code>false</code> otherwise
     */
    Boolean isSelectableChild(String templatePath); 
    
    /**
     * Indicates if the service has the property 'visible' set to true. If the
     * property is missing this method will return <code>true</code>.
     * 
     * @return <code>false</code> if the property is set to false,
     *         <code>true</code> otherwise or if the property is missing
     */
    Boolean isVisible();

}
