/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.ExpressionResolver;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.jsp.PageContext;
import org.apache.sling.api.SlingHttpServletRequest;

public class ExpressionHelper {
    private ExpressionResolver resolver;
    @Nonnull
    private SlingHttpServletRequest request;

    public ExpressionHelper(@Nonnull ExpressionResolver resolver, @Nonnull PageContext pageContext) {
        this(resolver, ExpressionHelper.toSlingRequest(pageContext.getRequest()));
    }

    public ExpressionHelper(@Nonnull ExpressionResolver resolver, @Nonnull SlingHttpServletRequest servletRequest) {
        this.resolver = resolver;
        this.request = servletRequest;
    }

    public String getString(@CheckForNull String expression) {
        return this.get(expression, String.class);
    }

    public String getString(@CheckForNull String expression, @Nonnull Locale locale) {
        return this.get(expression, locale, String.class);
    }

    public boolean getBoolean(@CheckForNull String expression) {
        Boolean result = this.get(expression, Boolean.class);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean getBoolean(@CheckForNull String expression, @Nonnull Locale locale) {
        Boolean result = this.get(expression, locale, Boolean.class);
        if (result == null) {
            return false;
        }
        return result;
    }

    public <T> T get(@CheckForNull String expression, @Nonnull Class<T> expectedType) {
        return this.get(expression, this.request.getLocale(), expectedType);
    }

    public <T> T get(@CheckForNull String expression, @Nonnull Locale locale, @Nonnull Class<T> expectedType) {
        if (expression == null) {
            return null;
        }
        return this.resolver.resolve(expression, locale, expectedType, this.request);
    }

    @Nonnull
    private static SlingHttpServletRequest toSlingRequest(@Nonnull ServletRequest req) {
        while (!(req instanceof SlingHttpServletRequest)) {
            if (req instanceof ServletRequestWrapper) {
                req = ((ServletRequestWrapper)req).getRequest();
                continue;
            }
            throw new IllegalStateException("request wrong class");
        }
        return (SlingHttpServletRequest)req;
    }
}

