/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.fontset.impl;

import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.util.HashMap;

public class CoreFontUtils {
    private static final String[] timesFamilyNames;
    private static final String[] timesBoldFamilyNames;
    private static final String[] timesItalicFamilyNames;
    private static final String[] timesBoldItalicFamilyNames;
    private static final String[] helveticaFamilyNames;
    private static final String[] helveticaBoldFamilyNames;
    private static final String[] helveticaItalicFamilyNames;
    private static final String[] helveticaBoldItalicFamilyNames;
    private static final String[] courierFamilyNames;
    private static final String[] courierBoldFamilyNames;
    private static final String[] courierItalicFamilyNames;
    private static final String[] courierBoldItalicFamilyNames;
    private static final String[] symbolFamilyNames;
    private static final String[] zapfDingbatsFamilyNames;
    public static final HashMap<ASName, ASName> standardFontsNames;

    protected CoreFontUtils() {
    }

    public static String[] getStandardFontNames(ASName fontName) {
        ASName standardFontProperName = standardFontsNames.get(fontName);
        if (standardFontProperName != null) {
            if (standardFontProperName == ASName.k_Times_Roman) {
                return timesFamilyNames;
            }
            if (standardFontProperName == ASName.k_Times_Bold) {
                return timesBoldFamilyNames;
            }
            if (standardFontProperName == ASName.k_Times_Italic) {
                return timesItalicFamilyNames;
            }
            if (standardFontProperName == ASName.k_Times_BoldItalic) {
                return timesBoldItalicFamilyNames;
            }
            if (standardFontProperName == ASName.k_Helvetica) {
                return helveticaFamilyNames;
            }
            if (standardFontProperName == ASName.k_Helvetica_Bold) {
                return helveticaBoldFamilyNames;
            }
            if (standardFontProperName == ASName.k_Helvetica_Oblique) {
                return helveticaItalicFamilyNames;
            }
            if (standardFontProperName == ASName.k_Helvetica_BoldOblique) {
                return helveticaBoldItalicFamilyNames;
            }
            if (standardFontProperName == ASName.k_Courier) {
                return courierFamilyNames;
            }
            if (standardFontProperName == ASName.k_Courier_Bold) {
                return courierBoldFamilyNames;
            }
            if (standardFontProperName == ASName.k_Courier_Oblique) {
                return courierItalicFamilyNames;
            }
            if (standardFontProperName == ASName.k_Courier_BoldOblique) {
                return courierBoldItalicFamilyNames;
            }
            if (standardFontProperName == ASName.k_Symbol) {
                return symbolFamilyNames;
            }
            if (standardFontProperName == ASName.k_ZapfDingbats) {
                return zapfDingbatsFamilyNames;
            }
        }
        return null;
    }

    static {
        int i;
        timesFamilyNames = new String[]{ASName.k_Times_Roman.asString(), ASName.k_TimesNewRomanPSMT.asString(), ASName.k_TimesNewRoman.asString(), ASName.k_TimesNewRomanPS.asString()};
        timesBoldFamilyNames = new String[]{ASName.k_Times_Bold.asString(), ASName.k_TimesNewRomanPS_BoldMT.asString(), ASName.k_TimesNewRomanCommaBold.asString(), ASName.k_TimesNewRomanPS_Bold.asString(), ASName.k_TimesNewRoman_Bold.asString()};
        timesItalicFamilyNames = new String[]{ASName.k_Times_Italic.asString(), ASName.k_TimesNewRomanPS_ItalicMT.asString(), ASName.k_TimesNewRomanCommaItalic.asString(), ASName.k_TimesNewRomanPS_Italic.asString(), ASName.k_TimesNewRoman_Italic.asString()};
        timesBoldItalicFamilyNames = new String[]{ASName.k_Times_BoldItalic.asString(), ASName.k_TimesNewRomanPS_BoldItalicMT.asString(), ASName.k_TimesNewRomanCommaBoldItalic.asString(), ASName.k_TimesNewRomanPS_BoldItalic.asString(), ASName.k_TimesNewRoman_BoldItalic.asString()};
        helveticaFamilyNames = new String[]{ASName.k_Helvetica.asString(), ASName.k_ArialMT.asString(), ASName.k_Arial.asString()};
        helveticaBoldFamilyNames = new String[]{ASName.k_Helvetica_Bold.asString(), ASName.k_Arial_BoldMT.asString(), ASName.k_ArialCommaBold.asString(), ASName.k_Arial_Bold.asString(), ASName.k_HelveticaCommaBold.asString()};
        helveticaItalicFamilyNames = new String[]{ASName.k_Helvetica_Oblique.asString(), ASName.k_Arial_ItalicMT.asString(), ASName.k_ArialCommaItalic.asString(), ASName.k_Arial_Italic.asString(), ASName.k_HelveticaCommaItalic.asString(), ASName.k_Helvetica_Italic.asString()};
        helveticaBoldItalicFamilyNames = new String[]{ASName.k_Helvetica_BoldOblique.asString(), ASName.k_Arial_BoldItalicMT.asString(), ASName.k_ArialCommaBoldItalic.asString(), ASName.k_Arial_BoldItalic.asString(), ASName.k_HelveticaCommaBoldItalic.asString(), ASName.k_Helvetica_BoldItalic.asString()};
        courierFamilyNames = new String[]{ASName.k_Courier.asString(), ASName.k_CourierNew.asString(), ASName.k_CourierNewPSMT.asString()};
        courierBoldFamilyNames = new String[]{ASName.k_Courier_Bold.asString(), ASName.k_CourierNewCommaBold.asString(), ASName.k_CourierCommaBold.asString(), ASName.k_CourierNewPS_BoldMT.asString(), ASName.k_CourierNew_Bold.asString()};
        courierItalicFamilyNames = new String[]{ASName.k_Courier_Oblique.asString(), ASName.k_CourierNewCommaItalic.asString(), ASName.k_CourierCommaItalic.asString(), ASName.k_CourierNewPS_ItalicMT.asString(), ASName.k_CourierNew_Italic.asString()};
        courierBoldItalicFamilyNames = new String[]{ASName.k_Courier_BoldOblique.asString(), ASName.k_CourierNewCommaBoldItalic.asString(), ASName.k_CourierCommaBoldItalic.asString(), ASName.k_CourierNewPS_BoldItalicMT.asString(), ASName.k_CourierNew_BoldItalic.asString()};
        symbolFamilyNames = new String[]{ASName.k_Symbol.asString(), "Symb"};
        zapfDingbatsFamilyNames = new String[]{ASName.k_ZapfDingbats.asString(), "ZaDb"};
        standardFontsNames = new HashMap(16, 0.5f);
        for (i = 0; i < timesFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(timesFamilyNames[i]), ASName.create(timesFamilyNames[0]));
        }
        for (i = 0; i < timesBoldFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(timesBoldFamilyNames[i]), ASName.create(timesBoldFamilyNames[0]));
        }
        for (i = 0; i < timesItalicFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(timesItalicFamilyNames[i]), ASName.create(timesItalicFamilyNames[0]));
        }
        for (i = 0; i < timesBoldItalicFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(timesBoldItalicFamilyNames[i]), ASName.create(timesBoldItalicFamilyNames[0]));
        }
        for (i = 0; i < helveticaFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(helveticaFamilyNames[i]), ASName.create(helveticaFamilyNames[0]));
        }
        for (i = 0; i < helveticaBoldFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(helveticaBoldFamilyNames[i]), ASName.create(helveticaBoldFamilyNames[0]));
        }
        for (i = 0; i < helveticaItalicFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(helveticaItalicFamilyNames[i]), ASName.create(helveticaItalicFamilyNames[0]));
        }
        for (i = 0; i < helveticaBoldItalicFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(helveticaBoldItalicFamilyNames[i]), ASName.create(helveticaBoldItalicFamilyNames[0]));
        }
        for (i = 0; i < courierFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(courierFamilyNames[i]), ASName.create(courierFamilyNames[0]));
        }
        for (i = 0; i < courierBoldFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(courierBoldFamilyNames[i]), ASName.create(courierBoldFamilyNames[0]));
        }
        for (i = 0; i < courierItalicFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(courierItalicFamilyNames[i]), ASName.create(courierItalicFamilyNames[0]));
        }
        for (i = 0; i < courierBoldItalicFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(courierBoldItalicFamilyNames[i]), ASName.create(courierBoldItalicFamilyNames[0]));
        }
        for (i = 0; i < symbolFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(symbolFamilyNames[i]), ASName.create(symbolFamilyNames[0]));
        }
        for (i = 0; i < zapfDingbatsFamilyNames.length; ++i) {
            standardFontsNames.put(ASName.create(zapfDingbatsFamilyNames[i]), ASName.create(zapfDingbatsFamilyNames[0]));
        }
    }
}

