/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Chars;
import com.adobe.xfa.Delta;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNodeScript;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.ut.ExFull;

public class TextNode
extends Chars {
    private boolean mbIsFragment;

    public TextNode(Element parent, Node prevSibling, String text) {
        super(parent, prevSibling, text);
        this.setClass("#text", 0);
    }

    public TextNode(Element parent, Node prevSibling, char[] text, int start, int length) {
        super(parent, prevSibling, text, start, length);
        this.setClass("#text", 0);
    }

    @Override
    public Node clone(Element parent) {
        return new TextNode(parent, null, this.getValue());
    }

    public TextNode createProto(Element oParent, String text, boolean bFull) {
        assert (oParent != null);
        boolean bMute = false;
        TextNode oRetNode = null;
        try {
            Model oModel;
            if (oParent != null && !bFull) {
                bMute = oParent.isMute();
                oParent.mute();
            }
            if ((oRetNode = (oModel = oParent.getModel()).createTextNode(oParent, oParent.getLastXMLChild(), text)) != null) {
                if (this.isTransient() || oParent.isTransient()) {
                    oRetNode.isTransient(true, true);
                }
                if (!bFull) {
                    oRetNode.makeDefault();
                } else {
                    oRetNode.makeNonDefault(false);
                }
            }
            if (!bMute && oParent != null) {
                oParent.unMute();
            }
        }
        catch (ExFull oEx) {
            if (!bMute && oParent != null) {
                oParent.unMute();
            }
            throw oEx;
        }
        return oRetNode;
    }

    public void getDeltas(TextNode delta, XFAList list) {
        if (this.isSameClass(delta) && list != null) {
            Element parent = this.getXFAParent();
            Element deltaParent = delta.getXFAParent();
            Delta newDelta = null;
            newDelta = delta.getModel().getAppModel() != null && !delta.getModel().getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING) ? new Delta(parent, deltaParent, this, delta, "value") : new Delta(parent, deltaParent, this, delta, "");
            list.append(newDelta);
        }
    }

    @Override
    public ScriptTable getScriptTable() {
        return TextNodeScript.getScriptTable();
    }

    public String getValue() {
        return this.getText();
    }

    public void setValue(String value, boolean bNotify, boolean bDefault) {
        this.setText(value);
        if (!bDefault) {
            this.makeNonDefault(false);
        }
        if (bNotify) {
            this.notifyPeers(2, "", null);
        }
    }

    public boolean isFragment() {
        return this.mbIsFragment;
    }

    public void isFragment(boolean bFragment) {
        Element parent;
        this.mbIsFragment = bFragment;
        if (!bFragment && (parent = this.getXMLParent()) != null && parent.isFragment()) {
            parent.isFragment(false, false);
        }
    }

    @Override
    public void makeNonDefault(boolean bRecursive) {
        super.makeNonDefault(bRecursive);
        if (this.isFragment()) {
            this.isFragment(false);
            this.isTransient(false, false);
        }
    }

    void restoreDelta(TextNode delta) {
        Element parent = this.getXFAParent();
        if (parent != null) {
            delta.remove();
            this.remove();
            parent.appendChild(delta, false);
            delta.makeNonDefault(false);
        }
    }

    String trimTrailingZeros(String sSource) {
        int nKeep = sSource.length();
        boolean bRadixFound = false;
        for (int i = 0; i < sSource.length(); ++i) {
            if (sSource.charAt(i) == '.') {
                bRadixFound = true;
                nKeep = i;
                continue;
            }
            if (!bRadixFound || !Character.isDigit(sSource.charAt(i)) || sSource.charAt(i) == '0') continue;
            nKeep = i + 1;
        }
        return sSource.substring(0, nKeep);
    }

    @Override
    protected boolean compareVersions(Node oRollbackTextNode, Node oContainer, Node.ChangeLogger oChangeLogger, Object oUserData) {
        boolean bMatches = this.compareVersionsBasic(oRollbackTextNode, oContainer, oChangeLogger, oUserData);
        if (!bMatches) {
            return false;
        }
        String sValue = ((TextNode)oRollbackTextNode).getValue();
        if (!this.getValue().equalsIgnoreCase(sValue)) {
            String sSanitizedRollback;
            String sSanitizedValue;
            bMatches = false;
            Element oParent = this.getXFAParent();
            if (oParent != null && (oParent.isSameClass(137) || oParent.isSameClass(92)) && (sSanitizedValue = this.trimTrailingZeros(this.getValue())).equalsIgnoreCase(sSanitizedRollback = this.trimTrailingZeros(sValue))) {
                bMatches = true;
            }
            if (!bMatches && oChangeLogger != null) {
                this.logValueChangeHelper(oContainer, this.getValue(), oChangeLogger, oUserData);
            }
        }
        return bMatches;
    }
}

