/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

final class FormCalcUtil {
    static final int MAX_PRECISION = 15;
    static final DecimalFormat gNumberFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    static final String hex = "0123456789ABCDEF0123456789abcdef";

    private FormCalcUtil() {
    }

    static String dblToStr(double d, int p) {
        int i;
        if (p > 15) {
            p = 15;
        }
        StringBuilder f = new StringBuilder();
        if (p > 15) {
            p = 15;
        }
        for (i = 0; i < 18 - p - 1; ++i) {
            f.append('#');
        }
        f.append('0');
        f.append('.');
        for (i = 0; i < p; ++i) {
            f.append('0');
        }
        DecimalFormat oNumberFormat = (DecimalFormat)gNumberFormat.clone();
        oNumberFormat.applyPattern(f.toString());
        oNumberFormat.setDecimalSeparatorAlwaysShown(true);
        return oNumberFormat.format(d);
    }

    static int trimZeroes(StringBuilder str) {
        assert (str != null);
        int dot = str.indexOf(".");
        int s = 0;
        if (dot >= 0) {
            s = dot;
        }
        int e = str.length() - 1;
        while (e >= s && str.charAt(e) == '0') {
            str.deleteCharAt(e--);
        }
        return str.length();
    }

    static int trimRadix(StringBuilder str) {
        assert (str != null);
        int e = str.length() - 1;
        if (e >= 0 && str.charAt(e) == '.') {
            str.deleteCharAt(e);
        }
        return str.length();
    }

    static int trimSign(StringBuilder str) {
        assert (str != null);
        String src = str.toString();
        if ("+0".equals(src) || "-0".equals(src)) {
            str.deleteCharAt(0);
        } else if (src.length() >= 1 && src.charAt(0) == '+') {
            str.deleteCharAt(0);
        }
        return str.length();
    }

    static double strToDbl(String str, boolean bAllowNaN) {
        double n;
        block3: {
            assert (str != null);
            n = 0.0;
            try {
                n = Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                if (!bAllowNaN) break block3;
                n = Double.NaN;
            }
        }
        return n;
    }

    static boolean strIsNumeric(String str) {
        if (str == null) {
            return false;
        }
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    static String interpolate(String src) {
        assert (src != null);
        int srcLen = src.length() - 1;
        assert (src.charAt(0) == '\"');
        assert (src.charAt(srcLen) == '\"');
        StringBuilder buf = new StringBuilder(srcLen);
        for (int i = 1; i < srcLen; ++i) {
            int k;
            int ch = src.charAt(i);
            if (ch == 34 && src.charAt(i + 1) == '\"') {
                buf.append((char)ch);
                ++i;
                continue;
            }
            if (ch == 92 && src.charAt(i + 1) == 'u' && i + 5 < srcLen && FormCalcUtil.isXDigit(src.charAt(i + 2)) && FormCalcUtil.isXDigit(src.charAt(i + 3)) && FormCalcUtil.isXDigit(src.charAt(i + 4)) && FormCalcUtil.isXDigit(src.charAt(i + 5))) {
                ch = 0;
                for (k = 0; k < 4; ++k) {
                    ch <<= 4;
                    ch += hex.indexOf(src.charAt(i + 2 + k)) & 0xF;
                }
                buf.append((char)ch);
                i += 5;
                continue;
            }
            if (ch == 92 && src.charAt(i + 1) == 'U' && i + 9 < srcLen && FormCalcUtil.isXDigit(src.charAt(i + 2)) && FormCalcUtil.isXDigit(src.charAt(i + 3)) && FormCalcUtil.isXDigit(src.charAt(i + 4)) && FormCalcUtil.isXDigit(src.charAt(i + 5)) && FormCalcUtil.isXDigit(src.charAt(i + 6)) && FormCalcUtil.isXDigit(src.charAt(i + 7)) && FormCalcUtil.isXDigit(src.charAt(i + 8)) && FormCalcUtil.isXDigit(src.charAt(i + 9))) {
                ch = 0;
                for (k = 0; k < 8; ++k) {
                    ch <<= 4;
                    ch += hex.indexOf(src.charAt(i + 2 + k)) & 0xF;
                }
                buf.append((char)((ch -= 65536) >> 10 | 0xD800));
                buf.append((char)(ch & 0x3FF | 0xDC00));
                i += 9;
                continue;
            }
            buf.append((char)ch);
        }
        src = buf.toString();
        Surrogate seen = Surrogate.Non;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if ('\ud800' <= c && c <= '\udbff') {
                if (seen == Surrogate.High) {
                    return null;
                }
                seen = Surrogate.High;
                continue;
            }
            if ('\udc00' <= c && c <= '\udfff') {
                if (seen != Surrogate.High) {
                    return null;
                }
                seen = Surrogate.Low;
                continue;
            }
            if (seen == Surrogate.High) {
                return null;
            }
            seen = Surrogate.Non;
        }
        return src;
    }

    static String strToEscStr(String src) {
        assert (src != null);
        int dbq = 0;
        int len = src.length();
        for (int s = 0; s < len; ++s) {
            if (src.charAt(s) != '\"') continue;
            ++dbq;
        }
        if (dbq > 0) {
            StringBuilder dst = new StringBuilder(len + dbq);
            dst.setLength(len + dbq);
            int p = len - 1;
            int q = len + dbq - 1;
            do {
                if (src.charAt(p) == '\"') {
                    dst.setCharAt(q--, '\"');
                }
                dst.setCharAt(q--, src.charAt(p--));
            } while (p >= 0);
            return dst.toString();
        }
        return src;
    }

    private static boolean isXDigit(char cChar) {
        return Character.isDigit(cChar) || 'a' <= cChar && cChar <= 'f' || 'A' <= cChar && cChar <= 'F';
    }

    private static enum Surrogate {
        Non,
        High,
        Low;

    }
}

