/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;

public final class Base64 {
    private static final char cBase64Pad = '=';
    private static final byte[] szBase64Decoding = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 62, 127, 127, 127, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 127, 127, 127, 127, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 127, 127, 127, 127, 127, 127, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 127, 127, 127, 127, 127};
    private static final String szBase64Encoding = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    private static void decode(byte[] pData, String pEncoded) {
        char iChar;
        int nCount = 0;
        int nAccumulator = 0;
        int nBits = 0;
        int resultPos = 0;
        if (pEncoded.length() == 0) {
            return;
        }
        while (nCount < pEncoded.length() && (iChar = pEncoded.charAt(nCount)) != '=') {
            if (iChar < '!' && (iChar == '\n' || iChar == '\r' || iChar == ' ' || iChar == '\t')) {
                ++nCount;
                continue;
            }
            if (iChar > '\u007f' || szBase64Decoding[iChar] > 63) {
                throw new ExFull(ResId.ILLEGAL_BASE64_ENCODING);
            }
            byte nDecodedChar = szBase64Decoding[iChar];
            nAccumulator <<= 6;
            nAccumulator |= nDecodedChar;
            if ((nBits += 6) >= 8) {
                pData[resultPos++] = (byte)(nAccumulator >> nBits - 8);
                nBits -= 8;
            }
            ++nCount;
        }
        if (nBits != 0 && (nAccumulator & ~(-1 << nBits)) != 0) {
            throw new ExFull(ResId.ILLEGAL_BASE64_ENCODING);
        }
    }

    public static byte[] decode(String sEncoded) {
        int nBufferLength = Base64.decodeLength(sEncoded.length());
        byte[] szResult = new byte[nBufferLength];
        Base64.decode(szResult, sEncoded);
        return szResult;
    }

    private static int decodeLength(int nLength) {
        return (nLength + 3) / 4 * 3;
    }

    public static String encode(byte[] pData, boolean bBreakLines) {
        String sResult = "";
        if (pData != null && pData.length != 0) {
            char[] pEncoded = new char[Base64.encodeLength(pData.length, bBreakLines)];
            Base64.encode(pEncoded, pData, bBreakLines);
            sResult = new String(pEncoded);
        }
        return sResult;
    }

    public static void encode(char[] pEncoded, byte[] pData, boolean bBreakLines) {
        int nAccumulator = 0;
        int nBits = 0;
        int nChars = 0;
        int nTotal = 0;
        if (pData == null || pData.length == 0) {
            pEncoded[0] = '\u0000';
            return;
        }
        for (int nCount = 0; nCount < pData.length; ++nCount) {
            if (bBreakLines && nChars % 76 == 0 && nChars != 0) {
                pEncoded[nTotal++] = 10;
            }
            nAccumulator <<= 8;
            nAccumulator = (int)((long)nAccumulator | (long)pData[nCount] & 0xFFL);
            nBits += 8;
            while (nBits >= 6) {
                pEncoded[nTotal++] = szBase64Encoding.charAt(nAccumulator >> nBits - 6 & 0x3F);
                ++nChars;
                nBits -= 6;
            }
        }
        if (nBits != 0) {
            pEncoded[nTotal++] = szBase64Encoding.charAt(nAccumulator << 6 - nBits & 0x3F);
            pEncoded[nTotal++] = 61;
            if (pData.length % 3 == 1) {
                pEncoded[nTotal++] = 61;
            }
        }
    }

    private static int encodeLength(int nSize, boolean bBreakLines) {
        if (nSize == 0) {
            return 0;
        }
        int nResult = (nSize + 2) / 3 * 4;
        if (bBreakLines) {
            nResult += (nResult - 1) / 76;
        }
        return nResult;
    }
}

