/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.wsdl;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.wsdl.WSDLDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WSDLNode
extends Element {
    public static final int WSDL_UNKNOWN = 0;
    public static final int WSDL_DOCUMENT = 1;
    public static final int WSDL_DEFINITIONS = 2;
    public static final int WSDL_TYPES = 3;
    public static final int WSDL_MESSAGE = 4;
    public static final int WSDL_PART = 5;
    public static final int WSDL_OPERATION = 6;
    public static final int WSDL_PORTTYPE = 7;
    public static final int WSDL_BINDING = 8;
    public static final int WSDL_BINDING_OPERATION = 9;
    public static final int WSDL_SERVICE = 10;
    public static final int WSDL_INPUT = 11;
    public static final int WSDL_OUTPUT = 12;
    public static final int WSDL_FAULT = 13;
    public static final int WSDL_PORT = 14;
    public static final int WSDL_EXTEN = 15;
    public static final int WSDLA_BINDING = 0;
    public static final int WSDLA_ELEMENT = 1;
    public static final int WSDLA_MESSAGE = 2;
    public static final int WSDLA_NAME = 3;
    public static final int WSDLA_NAMESPACE = 4;
    public static final int WSDLA_PARAMETERORDER = 5;
    public static final int WSDLA_TYPE = 6;
    public static final int WSDLA_MAX = 7;
    private static final String[] mAttrList = new String[]{"binding", "element", "message", "name", "namespace", "parameterOrder", "type"};
    private Element moDomNode;
    private WSDLDocument mpoOwner;
    private WSDLNode mpParentNode;
    private int meNodeType;
    private String msWSDLName = "";
    private String msPrefix;
    private String msNamespaceURI;
    private String msTargetNamespace;
    private Map<String, String> mPrefixToNS;
    private Map<String, String> mNSToPrefix;

    public WSDLNode(WSDLDocument poDocument, Element oSrc, int eType) {
        this.mpoOwner = poDocument;
        this.mpParentNode = null;
        this.moDomNode = oSrc;
        this.meNodeType = eType;
        this.loadNamespaces();
    }

    public int getNodeType() {
        return this.meNodeType;
    }

    public WSDLDocument getWSDLOwnerDocument() {
        return this.mpoOwner;
    }

    public WSDLNode getWSDLParentNode() {
        return this.mpParentNode;
    }

    public WSDLNode getWSDLChildNode(int inType, String inName) {
        String localName = inName;
        if (!StringUtils.isEmpty(inName)) {
            WSDLDocument.PrefixParseInfo prefixParseInfo = this.getWSDLOwnerDocument().checkAndParsePrefix(inName, this);
            if (prefixParseInfo == null) {
                return null;
            }
            localName = prefixParseInfo.mLocalName;
        }
        for (WSDLNode node = this.getFirstWSDLNode(); node != null; node = node.getNextWSDLNode()) {
            int nodeType = node.getNodeType();
            if (nodeType != inType) continue;
            if (StringUtils.isEmpty(localName)) {
                return node;
            }
            if (!StringUtils.equalsWithNull(node.getWSDLName(), localName)) continue;
            return node;
        }
        return null;
    }

    public WSDLNode getWSDLChildNode(int inType, String inName, String inTargetNS) {
        String localName = inName;
        for (WSDLNode node = this.getFirstWSDLNode(); node != null; node = node.getNextWSDLNode()) {
            int nodeType = node.getNodeType();
            if (nodeType != inType || !StringUtils.equalsWithNull(node.getWSDLName(), localName) || !StringUtils.equalsWithNull(node.getTargetNamespace(), inTargetNS)) continue;
            return node;
        }
        return null;
    }

    public List<WSDLNode> getWSDLChildNodesOfType(int inType) {
        ArrayList<WSDLNode> outNodesArray = new ArrayList<WSDLNode>();
        for (WSDLNode node = this.getFirstWSDLNode(); node != null; node = node.getNextWSDLNode()) {
            if (node.getNodeType() != inType) continue;
            outNodesArray.add(node);
        }
        return outNodesArray;
    }

    public String getNamespaceURI() {
        return this.msNamespaceURI;
    }

    public void setNamespaceURI(String sNSURI) {
        this.msNamespaceURI = sNSURI;
    }

    public String getTargetNamespace() {
        return this.msTargetNamespace;
    }

    public void setTargetNamespace(String sTargetNS) {
        this.msTargetNamespace = sTargetNS;
    }

    public String getNSURI(String sPrefix) {
        String value;
        if (this.mPrefixToNS != null && (value = this.mPrefixToNS.get(sPrefix)) != null) {
            return value;
        }
        Element parent = this.getXMLParent();
        if (parent instanceof WSDLNode) {
            WSDLNode wsdlParent = (WSDLNode)parent;
            return wsdlParent.getNSURI(sPrefix);
        }
        return "";
    }

    public String getNSPrefix(String sURI) {
        String value = this.mNSToPrefix.get(sURI);
        return value == null ? "" : value;
    }

    public String getWSDLName() {
        return this.msWSDLName;
    }

    public void setWSDLName(String sNodeName) {
        this.msWSDLName = sNodeName;
    }

    public String getWSDLPrefix() {
        return this.msPrefix;
    }

    public void setWSDLPrefix(String sPrefix) {
        this.msPrefix = sPrefix;
    }

    public Element getDomNode() {
        return this.moDomNode;
    }

    public String getWSDLAttribute(int eNodeAttribute) {
        return this.getWSDLAttribute(mAttrList, eNodeAttribute);
    }

    final String getWSDLAttribute(String[] attrList, int index) {
        int attrIndex;
        String result = null;
        if (index >= 0 && index < attrList.length && (attrIndex = this.moDomNode.findAttr(null, attrList[index])) >= 0) {
            result = this.moDomNode.getAttrVal(attrIndex);
        }
        return result == null ? "" : result;
    }

    final void appendWSDLChild(WSDLNode child) {
        this.appendChild(child);
        child.mpParentNode = this;
    }

    final WSDLNode getFirstWSDLNode() {
        return this.getFirstWSDLNode(0);
    }

    final WSDLNode getFirstWSDLNode(int nodeType) {
        return WSDLNode.getNextWSDLNode(this.getFirstXMLChild(), nodeType, false);
    }

    final WSDLNode getNextWSDLNode() {
        return this.getNextWSDLNode(0);
    }

    final WSDLNode getNextWSDLNode(int nodeType) {
        return WSDLNode.getNextWSDLNode(this, nodeType, true);
    }

    private static final WSDLNode getNextWSDLNode(Node node, int nodeType, boolean skipFirst) {
        while (node != null) {
            if (skipFirst) {
                skipFirst = false;
            } else if (node instanceof WSDLNode) {
                WSDLNode wsdlNode = (WSDLNode)node;
                if (nodeType == 0 || wsdlNode.getNodeType() == nodeType) {
                    return wsdlNode;
                }
            }
            node = node.getNextXMLSibling();
        }
        return null;
    }

    private void loadNamespaces() {
        if (this.moDomNode == null) {
            return;
        }
        int attrCount = this.moDomNode.getNumAttrs();
        for (int i = 0; i < attrCount; ++i) {
            String attrName = this.moDomNode.getAttrQName(i);
            int pos = attrName.indexOf(58);
            if (pos < 0 || !attrName.substring(0, pos).equals("xmlns")) continue;
            String prefix = this.moDomNode.getAttrName(i);
            String namespace = this.moDomNode.getAttrVal(i);
            if (this.mPrefixToNS == null) {
                this.mPrefixToNS = new HashMap<String, String>();
            }
            this.mPrefixToNS.put(prefix, namespace);
            if (this.mNSToPrefix == null) {
                this.mNSToPrefix = new HashMap<String, String>();
            }
            this.mNSToPrefix.put(namespace, prefix);
        }
    }
}

