/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import com.day.cq.commons.predicate.AbstractResourcePredicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.commons.UGCUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceSearch {
    private SlingRepository repository;
    private static final Logger log = LoggerFactory.getLogger(ReferenceSearch.class);
    private String searchRoot = "/";
    private boolean exact = false;
    private boolean hollow = false;
    private int maxReferencesPerPage = -1;
    private AbstractResourcePredicate resourcePredicate = null;
    private static final int DEFAULT_LIMIT = 100;
    private static final int DEFAULT_START_OFFSET = 0;

    public ReferenceSearch setRepository(SlingRepository repository) {
        this.repository = repository;
        return this;
    }

    public String getSearchRoot() {
        return this.searchRoot;
    }

    public ReferenceSearch setSearchRoot(String searchRoot) {
        this.searchRoot = searchRoot == null || searchRoot.equals("") ? "/" : searchRoot;
        return this;
    }

    public boolean isExact() {
        return this.exact;
    }

    public ReferenceSearch setExact(boolean exact) {
        this.exact = exact;
        return this;
    }

    public boolean isHollow() {
        return this.hollow;
    }

    public ReferenceSearch setHollow(boolean hollow) {
        this.hollow = hollow;
        return this;
    }

    public int getMaxReferencesPerPage() {
        return this.maxReferencesPerPage;
    }

    public ReferenceSearch setMaxReferencesPerPage(int maxReferencesPerPage) {
        this.maxReferencesPerPage = maxReferencesPerPage;
        return this;
    }

    public ReferenceSearch setPredicate(AbstractResourcePredicate resourcePredicate) {
        this.resourcePredicate = resourcePredicate;
        return this;
    }

    private Iterator<Resource> buildQueryAndFetchResults(ResourceResolver resolver, String root, List<String> pathList, int offset, int limit, String nodeType) {
        QueryBuilder queryBuilder = resolver.adaptTo(QueryBuilder.class);
        HashMap<String, String> map = new HashMap<String, String>();
        if (offset < 0) {
            offset = 0;
        }
        if (limit <= 0) {
            limit = 100;
        }
        if (!root.trim().isEmpty()) {
            map.put("path", root);
        }
        if (nodeType != null && !nodeType.trim().isEmpty()) {
            map.put("type", "cq:Page");
        }
        map.put("p.guessTotal", "true");
        map.put("p.offset", String.valueOf(offset));
        map.put("p.limit", String.valueOf(limit));
        int index = 1;
        for (String resourcePath : pathList) {
            if (resourcePath.trim().isEmpty()) continue;
            String predicateKey = String.format("group.%s_fulltext", index);
            map.put(predicateKey, resourcePath);
            ++index;
        }
        map.put("group.p.or", "true");
        Query query = queryBuilder.createQuery(PredicateGroup.create(map), resolver.adaptTo(Session.class));
        SearchResult result = query.getResult();
        return result.getResources();
    }

    public List<Page> findPageReferencesForResource(ResourceResolver resolver, String path, int limit, int offset) {
        if (path == null) {
            return Collections.emptyList();
        }
        ArrayList<Page> pageReferences = new ArrayList<Page>();
        String root = this.searchRoot.equals("/") ? "" : this.searchRoot;
        PageManager manager = resolver.adaptTo(PageManager.class);
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        ArrayList<String> pathList = new ArrayList<String>();
        this.prepareQueryInputs(patternList, pathList, path);
        Iterator<Resource> resources = this.buildQueryAndFetchResults(resolver, root, pathList, offset, limit, "cq:Page");
        resources.forEachRemaining(res -> {
            Page page = manager.getContainingPage((Resource)res);
            pageReferences.add(page);
            if (this.resourcePredicate != null && !this.resourcePredicate.evaluate((Resource)res)) {
                pageReferences.remove(page);
            }
        });
        return pageReferences;
    }

    public Map<String, Info> search(ResourceResolver resolver, String path, int limit, int offset) {
        if (path == null) {
            return Collections.emptyMap();
        }
        String root = this.searchRoot.equals("/") ? "" : this.searchRoot;
        PageManager manager = resolver.adaptTo(PageManager.class);
        HashMap<String, Info> infos = new HashMap<String, Info>();
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        ArrayList<String> pathList = new ArrayList<String>();
        this.prepareQueryInputs(patternList, pathList, path);
        Iterator<Resource> resources = this.buildQueryAndFetchResults(resolver, root, pathList, offset, limit, null);
        this.processResultset(resources, manager, infos, patternList);
        return infos;
    }

    private void prepareQueryInputs(List<Pattern> patternList, List<String> pathList, String path) {
        Pattern pattern = this.getSearchPattern(path);
        String qPath = ReferenceSearch.escapeIllegalXpathSearchChars(path);
        patternList.add(pattern);
        pathList.add(qPath);
        String escPath = Text.escapePath(path);
        if (!escPath.equals(path)) {
            Pattern escPattern = this.getSearchPattern(escPath);
            String qEscPath = ReferenceSearch.escapeIllegalXpathSearchChars(escPath);
            patternList.add(escPattern);
            pathList.add(qEscPath);
            escPath = this.escapePathUsingUpperCaseHex(path);
            Pattern escUppercasePattern = this.getSearchPattern(escPath);
            String qEscUppercasePath = ReferenceSearch.escapeIllegalXpathSearchChars(escPath);
            patternList.add(escUppercasePattern);
            pathList.add(qEscUppercasePath);
            if (escPath.contains("%26")) {
                escPath = escPath.replaceAll("%26", "&amp;");
                Pattern htmlEncodedescPattern = this.getSearchPattern(escPath);
                String qHtmlEncodeescPath = ReferenceSearch.escapeIllegalXpathSearchChars(escPath);
                patternList.add(htmlEncodedescPattern);
                pathList.add(qHtmlEncodeescPath);
            }
        }
    }

    public Map<String, Info> search(ResourceResolver resolver, String path) {
        if (path == null) {
            return Collections.emptyMap();
        }
        String root = this.searchRoot.equals("/") ? "" : this.searchRoot;
        PageManager manager = resolver.adaptTo(PageManager.class);
        HashMap<String, Info> infos = new HashMap<String, Info>();
        Pattern pattern = this.getSearchPattern(path);
        String qPath = ReferenceSearch.escapeIllegalXpathSearchChars(path);
        String query = String.format("%s//*[jcr:contains(., '\"%s\"')]", root, qPath);
        this.search(resolver, manager, infos, pattern, query);
        String escPath = Text.escapePath(path);
        if (!escPath.equals(path)) {
            Pattern escPattern = this.getSearchPattern(escPath);
            String qEscPath = ReferenceSearch.escapeIllegalXpathSearchChars(escPath);
            query = String.format("%s//*[jcr:contains(., '%s')]", root, qEscPath);
            this.search(resolver, manager, infos, escPattern, query);
            escPath = this.escapePathUsingUpperCaseHex(path);
            escPattern = this.getSearchPattern(escPath);
            qEscPath = ReferenceSearch.escapeIllegalXpathSearchChars(escPath);
            query = String.format("%s//*[jcr:contains(., '%s')]", root, qEscPath);
            this.search(resolver, manager, infos, escPattern, query);
            if (escPath.contains("%26")) {
                escPath = escPath.replaceAll("%26", "&amp;");
                escPattern = this.getSearchPattern(escPath);
                qEscPath = ReferenceSearch.escapeIllegalXpathSearchChars(escPath);
                query = String.format("%s//*[jcr:contains(., '%s')]", root, qEscPath);
                this.search(resolver, manager, infos, escPattern, query);
            }
        }
        return infos;
    }

    private void filterResultset(Map<String, Info> infos) {
        Iterator<Map.Entry<String, Info>> entries = infos.entrySet().iterator();
        while (entries.hasNext()) {
            Resource pageResource;
            Map.Entry<String, Info> entry = entries.next();
            if (entry.getValue().getProperties().isEmpty()) {
                entries.remove();
                continue;
            }
            if (this.resourcePredicate == null || entry.getValue().page == null || (pageResource = entry.getValue().page.adaptTo(Resource.class)) == null || this.resourcePredicate.evaluate(pageResource)) continue;
            entries.remove();
        }
    }

    private String escapePathUsingUpperCaseHex(String string) {
        try {
            BitSet validChars = Text.URISaveEx;
            int escape = 37;
            char[] hexTable = "0123456789ABCDEF".toCharArray();
            byte[] bytes = string.getBytes("utf-8");
            StringBuilder out = new StringBuilder(bytes.length);
            for (byte aByte : bytes) {
                int c = aByte & 0xFF;
                if (validChars.get(c) && c != escape) {
                    out.append((char)c);
                    continue;
                }
                out.append((char)escape);
                out.append(hexTable[c >> 4 & 0xF]);
                out.append(hexTable[c & 0xF]);
            }
            return out.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    private void search(ResourceResolver resolver, PageManager manager, Map<String, Info> infos, Pattern pattern, String query) {
        log.debug("Searching for references using: {}", (Object)query);
        Iterator<Resource> iter = null;
        try {
            iter = resolver.findResources(query, "xpath");
        }
        catch (SlingException e) {
            log.warn("error finding resources", e);
            return;
        }
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        patternList.add(pattern);
        this.processResultset(iter, manager, infos, patternList);
    }

    private void processResultset(Iterator<Resource> iter, PageManager manager, Map<String, Info> infos, List<Pattern> patternList) {
        log.debug("processing the search results and building the result set");
        while (iter.hasNext()) {
            Resource res = iter.next();
            Page page = manager.getContainingPage(res);
            if (page == null) continue;
            Info info = infos.get(page.getPath());
            if (info == null) {
                info = new Info(page, this.hollow);
                infos.put(page.getPath(), info);
            }
            try {
                Node node = res.adaptTo(Node.class);
                PropertyIterator pIter = node.getProperties();
                block3: while (pIter.hasNext() && (this.getMaxReferencesPerPage() < 0 || info.getProperties().size() < this.getMaxReferencesPerPage())) {
                    Property p = pIter.nextProperty();
                    if (p.getType() != 1 && p.getType() != 7) continue;
                    if (p.isMultiple()) {
                        for (Value v : p.getValues()) {
                            String value = v.getString();
                            if (!this.isPatternMatched(patternList, value)) continue;
                            info.addProperty(p.getPath());
                            continue block3;
                        }
                        continue;
                    }
                    String value = p.getString();
                    if (!this.isPatternMatched(patternList, value)) continue;
                    info.addProperty(p.getPath());
                }
            }
            catch (RepositoryException e) {
                log.error("Error while accessing " + res.getPath(), e);
            }
        }
        this.filterResultset(infos);
    }

    private boolean isPatternMatched(List<Pattern> patternList, String value) {
        boolean isPatternMatched = false;
        for (Pattern pattern : patternList) {
            isPatternMatched = pattern.matcher(value).find();
            if (!isPatternMatched) continue;
            return isPatternMatched;
        }
        return isPatternMatched;
    }

    public Collection<String> adjustReferences(ResourceResolver resolver, String path, String destination, String[] refPaths) {
        if (refPaths == null) {
            return Collections.emptyList();
        }
        HashSet<String> adjusted = new HashSet<String>();
        for (String p : refPaths) {
            Resource content;
            Resource r = resolver.getResource(p);
            if (r == null) {
                log.warn("Given path does not address a resource: {}", (Object)p);
                continue;
            }
            Page page = r.adaptTo(Page.class);
            if (page == null) {
                log.warn("Given path does not address a page: {}", (Object)p);
            }
            Resource resource = content = page != null ? page.getContentResource() : null;
            if (content == null) {
                log.warn("Given page does not have content: {}", (Object)p);
            }
            try {
                Node node = content != null ? content.adaptTo(Node.class) : r.adaptTo(Node.class);
                adjusted.addAll(this.adjustReferences(node, path, destination));
            }
            catch (RepositoryException e) {
                log.error("Error while adjusting references on " + r.getPath(), e);
            }
            try {
                String adjustedUGCPath = this.adjustUserGeneratedContentReference(r, path, destination);
                if (adjustedUGCPath == null) continue;
                adjusted.add(adjustedUGCPath);
                log.info("Adjusted user generated content path {}.", (Object)adjustedUGCPath);
            }
            catch (Exception e) {
                log.error("Error while adjusting user generated references on " + r.getPath(), e);
            }
        }
        PageManager pm = resolver.adaptTo(PageManager.class);
        for (String pathOfAdjusted : adjusted) {
            Resource adjustedResource = resolver.getResource(pathOfAdjusted);
            if (null == adjustedResource) continue;
            Page adjustedPage = pm.getContainingPage(adjustedResource);
            if (null != adjustedPage) {
                try {
                    pm.touch(adjustedPage.adaptTo(Node.class), true, Calendar.getInstance(), false);
                }
                catch (WCMException e) {
                    log.error("could not update last modified on adjusted page [{}]: ", (Object)adjustedPage.getPath(), (Object)e);
                }
            }
            this.touchIfContentFragmentReference(pathOfAdjusted, resolver);
        }
        try {
            resolver.commit();
        }
        catch (PersistenceException e) {
            log.error("Error while adjusting references.", e);
        }
        return adjusted;
    }

    private void touchIfContentFragmentReference(String adjustedPath, ResourceResolver resolver) {
        Resource contentRes;
        int lastIndexOfDelimiter = adjustedPath.lastIndexOf(this.searchRoot);
        String possibleCFRefPath = adjustedPath.substring(0, lastIndexOfDelimiter);
        Resource adjustedResource = resolver.getResource(possibleCFRefPath);
        if (adjustedResource != null && adjustedResource.getParent() != null && adjustedResource.getParent().getName().equals("data") && (contentRes = adjustedResource.getParent().getParent()) != null && contentRes.getName().equals("jcr:content")) {
            Boolean isContentFragment = (Boolean)((Object)contentRes.getValueMap().get("contentFragment", Boolean.class));
            this.touchCFLastModified(resolver, contentRes, isContentFragment);
        }
    }

    private void touchCFLastModified(ResourceResolver resolver, Resource contentRes, Boolean isContentFragment) {
        if (isContentFragment != null && isContentFragment.booleanValue()) {
            ModifiableValueMap properties = contentRes.adaptTo(ModifiableValueMap.class);
            if (properties != null) {
                properties.put("jcr:lastModified", Calendar.getInstance());
                properties.put("jcr:lastModifiedBy", resolver.getUserID());
                properties.put("lastFragmentSave", Calendar.getInstance());
            } else {
                log.warn("Cannot adapt " + contentRes.getPath() + " to ModifiableValueMap.");
                throw new IllegalStateException("properties should not be null, check logs for further investigation");
            }
        }
    }

    public Collection<String> adjustReferences(Node node, String path, String destination) throws RepositoryException {
        return this.adjustReferences(node, path, destination, false, Collections.emptySet());
    }

    public Collection<String> adjustReferences(Node node, String path, String destination, boolean shallow, Set<String> excludedProperties) throws RepositoryException {
        HashSet<String> adjusted = new HashSet<String>();
        Pattern pattern = this.getReplacementPattern(path);
        String escDest = Text.escapePath(destination);
        RangeIterator iter = node.getProperties();
        while (iter.hasNext()) {
            Property p = iter.nextProperty();
            if ((excludedProperties.contains(p.getName()) || p.getType() != 1) && p.getType() != 7 && p.getType() != 8) continue;
            if (p.isMultiple()) {
                Value[] values = p.getValues();
                boolean modified = false;
                for (int i = 0; i < values.length; ++i) {
                    String value = this.rewrite(values[i].getString(), path, pattern, destination, escDest);
                    if (value == null) continue;
                    values[i] = node.getSession().getValueFactory().createValue(value, p.getType());
                    modified = true;
                }
                if (!modified) continue;
                p.setValue(values);
                adjusted.add(p.getPath());
                log.info("Adjusted property {}.", (Object)p.getPath());
                continue;
            }
            String value = this.rewrite(p.getString(), path, pattern, destination, escDest);
            if (value == null) continue;
            p.setValue(value);
            adjusted.add(p.getPath());
            log.info("Adjusted property {}.", (Object)p.getPath());
        }
        if (!shallow) {
            iter = node.getNodes();
            while (iter.hasNext()) {
                adjusted.addAll(this.adjustReferences(iter.nextNode(), path, destination, shallow, excludedProperties));
            }
        }
        return adjusted;
    }

    private String adjustUserGeneratedContentReference(Resource resource, String path, String destination) throws RepositoryException, WCMException {
        String ugcPath = resource.getPath();
        if (ugcPath.startsWith("/content/usergenerated" + path)) {
            String newUgcPath = ugcPath.replaceFirst(path, destination);
            ResourceResolver resolver = resource.getResourceResolver();
            Resource newUgcResource = resolver.resolve(newUgcPath);
            if (ResourceUtil.isNonExistingResource(newUgcResource)) {
                PageManager pageManager = resolver.adaptTo(PageManager.class);
                String newUgcParentPath = Text.getRelativeParent(UGCUtil.UGCToResourcePath(newUgcResource), 1);
                UGCUtil.prepareUserGeneratedContent(resolver, newUgcParentPath);
                pageManager.move(resource, newUgcPath, Text.getName(resource.getPath()), true, true, new String[0]);
                return newUgcPath;
            }
        }
        return null;
    }

    protected Pattern getSearchPattern(String path) {
        if (this.exact) {
            return Pattern.compile("([\"']|^)(" + Pattern.quote(path) + ")([;.?#\"']|$)");
        }
        return Pattern.compile("([\"']|^)(" + Pattern.quote(path) + ")([;.?#\"'/](.*)|$)");
    }

    protected Pattern getReplacementPattern(String path) {
        String escPath = Text.escapePath(path);
        String literal = Pattern.quote(path);
        if (!escPath.equals(path)) {
            literal = literal + "|" + Pattern.quote(escPath);
            escPath = this.escapePathUsingUpperCaseHex(path);
            literal = literal + "|" + Pattern.quote(escPath);
            if (escPath.contains("%26")) {
                literal = literal + "|" + Pattern.quote(escPath.replaceAll("%26", "&amp;"));
            }
        }
        if (this.exact) {
            return Pattern.compile("([\"'])(" + literal + ")([;.?#\"'])");
        }
        return Pattern.compile("([\"'])(" + literal + ")([;.?#\"'/])");
    }

    protected String rewrite(String value, String from, Pattern p, String to, String escTo) {
        if (value.equals(from)) {
            return to;
        }
        if (value.startsWith(from + "#") || value.startsWith(from + ".html")) {
            return to + value.substring(from.length());
        }
        if (!this.exact && value.startsWith(from + "/")) {
            return to + value.substring(from.length());
        }
        Matcher m = p.matcher(value);
        StringBuffer ret = null;
        String repl = "$1" + escTo + "$3";
        while (m.find()) {
            if (ret == null) {
                ret = new StringBuffer();
            }
            m.appendReplacement(ret, repl);
        }
        if (ret == null) {
            return null;
        }
        m.appendTail(ret);
        return ret.toString();
    }

    public static String escapeIllegalXpathSearchChars(String s) {
        StringBuffer sb = new StringBuffer();
        for (char c : s.toCharArray()) {
            if (c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '{' || c == '}' || c == '?' || c == '\"' || c == '\\' || c == ' ' || c == '~') {
                sb.append('\\');
            } else if (c == '\'') {
                sb.append(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static final class Info {
        private final Page page;
        private final String pageTitle;
        private final String pagePath;
        private final Set<String> properties = new HashSet<String>();

        public Info(Page page) {
            this.page = page;
            this.pageTitle = page.getTitle();
            this.pagePath = page.getPath();
        }

        public Info(Page page, boolean hollow) {
            this.page = !hollow ? page : null;
            this.pageTitle = page.getTitle();
            this.pagePath = page.getPath();
        }

        private void addProperty(String path) {
            this.properties.add(path);
        }

        public Page getPage() {
            return this.page;
        }

        public Set<String> getProperties() {
            return this.properties;
        }

        public String getPageTitle() {
            return this.pageTitle;
        }

        public String getPagePath() {
            return this.pagePath;
        }
    }
}

