/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.ut.StringUtils;

public abstract class Attribute {
    private final String mQName;
    private final String mLocalName;
    private final String mPrefix;
    private String mVal;

    public Attribute(String qName, String value) {
        this(null, null, qName, value, true);
    }

    public Attribute(String NS, String localName, String qName, String value) {
        this(NS, localName, qName, value, true);
    }

    protected Attribute(String NS, String localName, String qName, String value, boolean internSymbols) {
        String prefix = "";
        assert (value != null);
        String string = this.mVal = value == null ? "" : value;
        if (qName != null) {
            int colon = qName.indexOf(58);
            if (localName != null && localName.length() != 0 && localName.indexOf(58) < 0) {
                if (internSymbols) {
                    localName = localName.intern();
                    qName = qName.intern();
                }
            } else {
                if (internSymbols) {
                    qName = qName.intern();
                }
                String string2 = localName = colon >= 0 ? qName.substring(colon + 1).intern() : qName;
            }
            if (colon == 5 && qName.startsWith("xmlns")) {
                prefix = "xmlns";
            } else if (colon > 0) {
                prefix = qName.substring(0, colon).intern();
            }
        } else if (localName != null) {
            if (internSymbols) {
                localName = localName.intern();
            }
            qName = localName;
        }
        this.mQName = qName;
        this.mLocalName = localName;
        this.mPrefix = prefix;
        if (this.mLocalName == "name" || this.isNameSpaceAttr()) {
            this.mVal = this.mVal.intern();
        }
    }

    public final String getAttrValue() {
        return this.mVal;
    }

    public final String getLocalName() {
        return this.mLocalName;
    }

    public final String getName() {
        return this.mLocalName;
    }

    public String getNS() {
        return null;
    }

    public final String getPrefix() {
        return this.mPrefix;
    }

    public final String getQName() {
        return this.mQName;
    }

    public final boolean isEmpty() {
        return StringUtils.isEmpty(this.getAttrValue());
    }

    public final boolean isNameSpaceAttr() {
        return this.getQName() == "xmlns" || this.getPrefix() == "xmlns";
    }

    public final boolean isXSINilAttr() {
        String localName = this.getLocalName();
        if (localName == "nil" || localName == "null") {
            String ns = this.getNS();
            if (ns == null) {
                return false;
            }
            return ns == "http://www.w3.org/2001/XMLSchema-instance" || ns.startsWith("http://www.w3.org/") && ns.endsWith("/XMLSchema-instance");
        }
        return false;
    }

    public boolean isSchemaAttr() {
        return true;
    }

    public abstract Attribute newAttribute(String var1);

    public abstract Attribute newAttribute(String var1, String var2, String var3, String var4);

    public abstract Attribute newAttribute(String var1, String var2, String var3, String var4, boolean var5);

    public void normalize() {
    }

    protected final void setAttrValue(String value) {
        this.mVal = value;
    }

    public String toString() {
        return this.mVal;
    }
}

