/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXMapping;
import com.adobe.xfa.gfx.GFXMappingList;

class MultiMapper {
    static final int GLYPH_CAN_ADD = 0;
    static final int GLYPH_FLUSH_FIRST = 1;
    static final int GLYPH_NOT_MULTIPLE = 2;
    private boolean mbAccumulating;
    private int mnCharIndex;
    private int mnGlyphFirst;
    private int mnGlyphNext;

    MultiMapper() {
    }

    MultiMapper(MultiMapper source) {
        this.mbAccumulating = source.mbAccumulating;
        this.mnCharIndex = source.mnCharIndex;
        this.mnGlyphFirst = source.mnGlyphFirst;
        this.mnGlyphNext = source.mnGlyphNext;
    }

    boolean isAccumulating() {
        return this.mbAccumulating;
    }

    int canAccumulate(GFXMapping oMapping, int nGlyphOffset) {
        if (oMapping.getCharCount() != 1) {
            return 2;
        }
        if (oMapping.getGlyphCount() == 0) {
            return 2;
        }
        MultiMapper oTester = new MultiMapper(this);
        int nCharIndex = oMapping.getCharIndex(0);
        for (int i = 0; i < oMapping.getGlyphCount(); ++i) {
            int nGlyphIndex = oMapping.getGlyphIndex(i) + nGlyphOffset;
            if (!oTester.canAccumulate(nCharIndex, nGlyphIndex)) {
                if (i == 0) {
                    return 1;
                }
                return 2;
            }
            oTester.accumulate(nCharIndex, nGlyphIndex);
        }
        return 0;
    }

    boolean canAccumulate(int nCharIndex, int nGlyphIndex) {
        if (!this.mbAccumulating) {
            return true;
        }
        if (nCharIndex != this.mnCharIndex) {
            return false;
        }
        return nGlyphIndex == this.mnGlyphNext || nGlyphIndex + 1 == this.mnGlyphFirst;
    }

    int getCharIndex() {
        return this.mnCharIndex;
    }

    int getGlyphIndex() {
        return this.mnGlyphFirst;
    }

    int getGlyphLength() {
        return this.mnGlyphNext - this.mnGlyphFirst;
    }

    void accumulate(GFXMapping oMapping, int nGlyphOffset) {
        assert (oMapping.getCharCount() == 1);
        assert (oMapping.getGlyphCount() != 0);
        int nCharIndex = oMapping.getCharIndex(0);
        for (int i = 0; i < oMapping.getGlyphCount(); ++i) {
            this.accumulate(nCharIndex, oMapping.getGlyphIndex(i) + nGlyphOffset);
        }
    }

    void accumulate(int nCharIndex, int nGlyphIndex) {
        if (!this.mbAccumulating) {
            this.mnCharIndex = nCharIndex;
            this.mnGlyphFirst = nGlyphIndex;
            this.mnGlyphNext = nGlyphIndex + 1;
            this.mbAccumulating = true;
        } else {
            assert (nCharIndex == this.mnCharIndex);
            if (nGlyphIndex == this.mnGlyphNext) {
                ++this.mnGlyphNext;
            } else {
                assert (nGlyphIndex + 1 == this.mnGlyphFirst);
                --this.mnGlyphFirst;
            }
        }
    }

    void flush(GFXMappingList oMappingList) {
        if (!this.mbAccumulating) {
            return;
        }
        oMappingList.addMapping(this.mnCharIndex, this.mnGlyphFirst, 1, this.mnGlyphNext - this.mnGlyphFirst);
        this.mbAccumulating = false;
    }

    void reset() {
        this.mbAccumulating = false;
    }
}

