/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.restriction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRestrictionProvider
implements RestrictionProvider,
AccessControlConstants {
    private final Map<String, RestrictionDefinition> supported;

    public AbstractRestrictionProvider(@NotNull Map<String, ? extends RestrictionDefinition> definitions) {
        this.supported = ImmutableMap.copyOf(definitions);
    }

    @Override
    @NotNull
    public Set<RestrictionDefinition> getSupportedRestrictions(@Nullable String oakPath) {
        if (this.isUnsupportedPath(oakPath)) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf(this.supported.values());
    }

    @Override
    @NotNull
    public Restriction createRestriction(@Nullable String oakPath, @NotNull String oakName, @NotNull Value value) throws RepositoryException {
        RestrictionDefinition definition = this.getDefinition(oakPath, oakName);
        Type<?> requiredType = definition.getRequiredType();
        int tag = requiredType.tag();
        if (tag != 0 && tag != value.getType()) {
            throw new AccessControlException("Unsupported restriction: Expected value of type " + requiredType + " for " + oakName);
        }
        PropertyState propertyState = requiredType.isArray() ? PropertyStates.createProperty(oakName, ImmutableList.of(value), tag) : PropertyStates.createProperty(oakName, value);
        return AbstractRestrictionProvider.createRestriction(propertyState, definition);
    }

    @Override
    @NotNull
    public Restriction createRestriction(@Nullable String oakPath, @NotNull String oakName, Value ... values) throws RepositoryException {
        PropertyState propertyState;
        RestrictionDefinition definition = this.getDefinition(oakPath, oakName);
        Type<?> requiredType = definition.getRequiredType();
        for (Value v : values) {
            if (requiredType.tag() == 0 || requiredType.tag() == v.getType()) continue;
            throw new AccessControlException("Unsupported restriction: Expected value of type " + requiredType + " for " + oakName);
        }
        if (requiredType.isArray()) {
            propertyState = PropertyStates.createProperty(oakName, Arrays.asList(values), requiredType.tag());
        } else {
            if (values.length != 1) {
                throw new AccessControlException("Unsupported restriction: Expected single value for " + oakName);
            }
            propertyState = PropertyStates.createProperty(oakName, values[0]);
        }
        return AbstractRestrictionProvider.createRestriction(propertyState, definition);
    }

    @Override
    @NotNull
    public Set<Restriction> readRestrictions(@Nullable String oakPath, @NotNull Tree aceTree) {
        if (this.isUnsupportedPath(oakPath)) {
            return Collections.emptySet();
        }
        HashSet<Restriction> restrictions = new HashSet<Restriction>();
        for (PropertyState propertyState : this.getRestrictionsTree(aceTree).getProperties()) {
            RestrictionDefinition def;
            String propName = propertyState.getName();
            if (!AbstractRestrictionProvider.isRestrictionProperty(propName) || !this.supported.containsKey(propName) || (def = this.supported.get(propName)).getRequiredType() != propertyState.getType()) continue;
            restrictions.add(AbstractRestrictionProvider.createRestriction(propertyState, def));
        }
        return restrictions;
    }

    @Override
    public void writeRestrictions(@Nullable String oakPath, @NotNull Tree aceTree, @NotNull Set<Restriction> restrictions) throws RepositoryException {
        if (!restrictions.isEmpty()) {
            Tree rTree = TreeUtil.getOrAddChild(aceTree, "rep:restrictions", "rep:Restrictions");
            for (Restriction restriction : restrictions) {
                rTree.setProperty(restriction.getProperty());
            }
        }
    }

    @Override
    public void validateRestrictions(@Nullable String oakPath, @NotNull Tree aceTree) throws AccessControlException {
        Map<String, PropertyState> restrictionProperties = this.getRestrictionProperties(aceTree);
        if (this.isUnsupportedPath(oakPath)) {
            if (!restrictionProperties.isEmpty()) {
                throw new AccessControlException("Restrictions not supported with 'null' path.");
            }
        } else {
            for (Map.Entry<String, PropertyState> entry : restrictionProperties.entrySet()) {
                String restrName = entry.getKey();
                RestrictionDefinition def = this.supported.get(restrName);
                if (def == null) {
                    throw new AccessControlException("Unsupported restriction: " + restrName);
                }
                Type<?> type = entry.getValue().getType();
                if (type == def.getRequiredType()) continue;
                throw new AccessControlException("Invalid restriction type '" + type + "' for " + restrName + ". Expected " + def.getRequiredType());
            }
            for (RestrictionDefinition def : this.supported.values()) {
                if (!def.isMandatory() || restrictionProperties.containsKey(def.getName())) continue;
                throw new AccessControlException("Mandatory restriction " + def.getName() + " is missing.");
            }
        }
    }

    protected boolean isUnsupportedPath(@Nullable String oakPath) {
        return oakPath == null;
    }

    @NotNull
    protected Tree getRestrictionsTree(@NotNull Tree aceTree) {
        Tree restrictions = aceTree.getChild("rep:restrictions");
        if (!restrictions.exists()) {
            restrictions = aceTree;
        }
        return restrictions;
    }

    @NotNull
    private RestrictionDefinition getDefinition(@Nullable String oakPath, @NotNull String oakName) throws AccessControlException {
        if (this.isUnsupportedPath(oakPath)) {
            throw new AccessControlException("Unsupported restriction at " + oakPath);
        }
        RestrictionDefinition definition = this.supported.get(oakName);
        if (definition == null) {
            throw new AccessControlException("Unsupported restriction: " + oakName);
        }
        return definition;
    }

    @NotNull
    private static Restriction createRestriction(@NotNull PropertyState propertyState, @NotNull RestrictionDefinition definition) {
        return new RestrictionImpl(propertyState, definition);
    }

    @NotNull
    private Map<String, PropertyState> getRestrictionProperties(@NotNull Tree aceTree) {
        Tree rTree = this.getRestrictionsTree(aceTree);
        HashMap<String, PropertyState> restrictionProperties = new HashMap<String, PropertyState>();
        for (PropertyState propertyState : rTree.getProperties()) {
            String name = propertyState.getName();
            if (!AbstractRestrictionProvider.isRestrictionProperty(name)) continue;
            restrictionProperties.put(name, propertyState);
        }
        return restrictionProperties;
    }

    private static boolean isRestrictionProperty(@NotNull String propertyName) {
        return !AccessControlConstants.ACE_PROPERTY_NAMES.contains(propertyName) && !"jcr".equals(Text.getNamespacePrefix(propertyName));
    }
}

