/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.jcr.Session;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReaderFactory;
import org.apache.sling.api.resource.ResourceResolver;

public class DiscoveryLiteDescriptor {
    public static final String OAK_DISCOVERYLITE_CLUSTERVIEW = "oak.discoverylite.clusterview";
    private static final JsonReaderFactory jsonReaderFactory;
    private final JsonObject descriptor;

    public static DiscoveryLiteDescriptor getDescriptorFrom(ResourceResolver resourceResolver) throws Exception {
        Session session = resourceResolver.adaptTo(Session.class);
        if (session == null) {
            throw new Exception("Could not adapt resourceResolver to session: " + resourceResolver);
        }
        String descriptorStr = session.getRepository().getDescriptor(OAK_DISCOVERYLITE_CLUSTERVIEW);
        if (descriptorStr == null) {
            throw new Exception("No value available for descriptor oak.discoverylite.clusterview");
        }
        JsonObject descriptor = jsonReaderFactory.createReader(new StringReader(descriptorStr)).readObject();
        return new DiscoveryLiteDescriptor(descriptor);
    }

    DiscoveryLiteDescriptor(JsonObject descriptor) {
        this.descriptor = descriptor;
    }

    public int getMyId() throws Exception {
        return this.descriptor.getInt("me");
    }

    private int[] getArray(String name) throws Exception {
        JsonArray deactivating = this.descriptor.getJsonArray(name);
        int[] result = new int[deactivating.size()];
        for (int i = 0; i < deactivating.size(); ++i) {
            result[i] = deactivating.getInt(i);
        }
        return result;
    }

    public int[] getDeactivatingIds() throws Exception {
        return this.getArray("deactivating");
    }

    public int[] getActiveIds() throws Exception {
        return this.getArray("active");
    }

    public String getViewId() throws Exception {
        if (this.descriptor.isNull("id")) {
            return null;
        }
        return this.descriptor.getString("id");
    }

    public String toString() {
        return this.getDescriptorStr();
    }

    public String getDescriptorStr() {
        StringWriter writer = new StringWriter();
        Json.createGenerator(writer).write(this.descriptor).close();
        return writer.toString();
    }

    public Long getSeqNum() throws Exception {
        return this.descriptor.getJsonNumber("seq").longValue();
    }

    public boolean isFinal() throws Exception {
        return this.descriptor.getBoolean("final");
    }

    static {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("org.apache.johnzon.supports-comments", true);
        jsonReaderFactory = Json.createReaderFactory(config);
    }
}

