/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.BlockingWriteCallback;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.message.Utf8CharBuffer;

@Deprecated(since="2021-05-27")
public class MessageWriter
extends Writer {
    private static final Logger LOG = Log.getLogger(MessageWriter.class);
    private final OutgoingFrames outgoing;
    private final ByteBufferPool bufferPool;
    private final BlockingWriteCallback blocker;
    private long frameCount;
    private TextFrame frame;
    private ByteBuffer buffer;
    private Utf8CharBuffer utf;
    private WriteCallback callback;
    private boolean closed;

    public MessageWriter(WebSocketSession session) {
        this(session.getOutgoingHandler(), session.getPolicy().getMaxTextMessageBufferSize(), session.getBufferPool());
    }

    public MessageWriter(OutgoingFrames outgoing, int bufferSize, ByteBufferPool bufferPool) {
        this.outgoing = outgoing;
        this.bufferPool = bufferPool;
        this.blocker = new BlockingWriteCallback();
        this.buffer = bufferPool.acquire(bufferSize, true);
        BufferUtil.flipToFill(this.buffer);
        this.frame = new TextFrame();
        this.utf = Utf8CharBuffer.wrap(this.buffer);
    }

    @Override
    public void write(char[] chars, int off, int len) throws IOException {
        try {
            this.send(chars, off, len);
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    @Override
    public void write(int c) throws IOException {
        try {
            this.send(new char[]{(char)c}, 0, 1);
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.flush(false);
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush(true);
            this.bufferPool.release(this.buffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream closed, {} frames sent", this.frameCount);
            }
            this.notifySuccess();
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean fin) throws IOException {
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            this.closed = fin;
            ByteBuffer data = this.utf.getByteBuffer();
            if (LOG.isDebugEnabled()) {
                LOG.debug("flush({}): {}", fin, BufferUtil.toDetailString(this.buffer));
            }
            this.frame.setPayload(data);
            this.frame.setFin(fin);
            try (BlockingWriteCallback.WriteBlocker b = this.blocker.acquireWriteBlocker();){
                this.outgoing.outgoingFrame(this.frame, b, BatchMode.OFF);
                b.block();
            }
            ++this.frameCount;
            this.frame.setIsContinuation();
            this.utf.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(char[] chars, int offset, int length) throws IOException {
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            while (length > 0) {
                int space = this.utf.remaining();
                int size = Math.min(space, length);
                this.utf.append(chars, offset, size);
                offset += size;
                if ((length -= size) <= 0) continue;
                this.flush(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(WriteCallback callback) {
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            this.callback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuccess() {
        WriteCallback callback;
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            callback = this.callback;
        }
        if (callback != null) {
            callback.writeSuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailure(Throwable failure) {
        WriteCallback callback;
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            callback = this.callback;
        }
        if (callback != null) {
            callback.writeFailed(failure);
        }
    }
}

