/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.wcm.style;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.osgi.annotation.versioning.ProviderType;

/**
 * A {@code StyleGroupInfo} provides methods for retrieving information about a style group.
 * It represents for example style resources defined in a content policy below a {@code cq:styleGroups} node.
 *
 * @since com.adobe.cq.wcm.style 1.0.0
 */
@ProviderType
public interface StyleGroupInfo {

    /**
     * Checks if the style group allows multiple selection of styles.
     *
     * @return {@code true} if multiple selection is possible, {@code false} otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    boolean allowsMultiple();

    /**
     * Retrieves the readable name of the style group.
     *
     * @return the readable name of the style group if defined, {@code null} otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nullable
    String getLabel();

    /**
     * Retrieves the styles that are part of this group.
     *
     * @return the {@code StyleInfo}s configured for the style group, an empty list otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nonnull
    List<StyleInfo> getStyles();

}
