/*
 * File: LigatureLevel.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.inlineformatting;

/** Enumerated values for {@link InterElementAttribute#ligatureLevel}.
 * 
 * Each value corresponds to one level of ligation, each level adding
 * more ligatures over the previous one.
 */
final public class LigatureLevel {
  private final String name;
  private final int rank;
  
  private LigatureLevel (String name, int rank) {
    this.name = name;
    this.rank = rank;
    }
  
  public String toString () {
    return name;
  }
  
  /** no ligation whatsoever */
  public static final LigatureLevel NONE = new LigatureLevel ("NONE", 0); 
  
  /** only the ligatures needed for legible rendering */
  public static final LigatureLevel MINIMUM = new LigatureLevel ("MINIMUM", 1);
  
  /** common ligatures */
  public static final LigatureLevel COMMON = new LigatureLevel ("COMMON", 2);
  
  /** uncommon ligatures */
  public static final LigatureLevel UNCOMMON = new LigatureLevel ("UNCOMMON", 3);
  
  /** exoctic ligatures */
  public static final LigatureLevel EXOTIC = new LigatureLevel ("EXOTIC", 4);
  
  /** Compare two levels.
   * The ordering is <code>NONE</code> &lt; <code>MINIMUM</code> &lt;
   * <code>COMMON</code> &lt; <code>UNCOMMON</code> &lt; <code>EXOTIC</code>.
   */
  public static boolean lessThanOrEqual (LigatureLevel l1, LigatureLevel l2) {
    if (l1 == null) {
      l1 = LigatureLevel.COMMON; }
    if (l2 == null) {
      l2 = LigatureLevel.COMMON; }
    return l1.rank <= l2.rank;  
  }
  
  private static final LigatureLevel[] allValues 
  = {NONE, MINIMUM, COMMON, UNCOMMON, EXOTIC};

  public static LigatureLevel parse (String s) {
    for (int i = 0; i < allValues.length; i++) {
      if (allValues [i].name.compareToIgnoreCase (s) == 0) {
        return allValues [i]; }}
    return null;
  }
}
