/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.granite.socketio;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.osgi.annotation.versioning.ConsumerType;

/**
* Socket.IO listener.
*/
@ConsumerType
public interface SocketIOListener {

    /**
     * Checks whether this listener wants to handle events for the given namespace.
     * @param name name of the namespace to check.
     * @return {@code true} if this listener will handle events for this namespace.
     */
    boolean handleNamespace(@Nonnull String name);

    /**
     * Called when a socket connects.
     * @param socket the socket.
     */
    void onConnect(@Nonnull SocketIOSocket socket);

    /**
     * Called when a socket disconnects. Note that prior to this, the socket listener on the socket is called.
     * @param socket the socket that disconnected.
     * @param reason informative reason
     */
    void onDisconnect(@Nonnull SocketIOSocket socket, @Nullable String reason);
}