/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.translation.core;

import org.apache.sling.api.resource.Resource;

public interface TranslationCloudConfigUtil {

    public String getCloudConfigPathAppliedOnResource(Resource resource, Class<?> cloudConfigClass);

    public String getCloudConfigPathAppliedOnResource(Resource resource, String strCloudConfigResourceType);

    /**
     * @deprecated since 6.4, use {@link #getCloudConfigObjectFromPath(Resource, Class, String)} instead
     */
    @Deprecated
    public Object getCloudConfigObjectFromPath(Class<?> cloudConfigClass, String cloudConfigPath);

    /**
     * Retrieve the context aware cloud configuration at {@code cloudConfigPath} that has been applied on the {@code resource}
     * @param resource the resource on which the cloud config is applied
     * @param cloudConfigClass the type of the cloud config
     * @param cloudConfigPath path of the cloud config
     * @return
     */
    public Object getCloudConfigObjectFromPath(Resource resource, Class<?> cloudConfigClass, String cloudConfigPath);

    public boolean isCloudConfigAppliedOnImmediateResource(Resource translationConfigResource, String resourceType);
}
