/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2013 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components.formbuilder;

import java.util.HashMap;

import javax.annotation.Nonnull;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface FormResourceManager {

    /**
     * Returns a generic form field resource.
     *
     * @param formResource
     *            the form resource
     * @return a generic form field resource
     */
    @Nonnull
    Resource getFormFieldResource(@Nonnull Resource formResource);

    /**
     * Returns a generic form field resource.
     *
     * @param formResource
     *            the form resource
     * @param label
     *            the label
     * @return a generic form field resource
     */
    @Nonnull
    Resource getFormFieldResource(@Nonnull Resource formResource, @Nonnull String label);

    /**
     * Returns a form drop down resource.
     *
     * @param formResource
     *            the form resource
     * @return a form drop down resource
     */
    @Nonnull
    Resource getFormDropdownResource(@Nonnull Resource formResource);

    /**
     * Returns a drop down option resource.
     *
     * @param formResource
     *            the form resource
     * @return a drop down option resource
     */
    @Nonnull
    Resource getDropdownOptionResource(@Nonnull Resource formResource);

    /**
     * Returns a checkbox field resource.
     *
     * @param formResource
     *            the form resource
     * @return a checkbox field resource
     */
    @Nonnull
    Resource getCheckboxFieldResource(@Nonnull Resource formResource);

    /**
     * Returns a checkbox field resource.
     *
     * @param formResource
     *            the form resource
     * @param label
     *            the label
     * @return a checkbox field resource
     */
    @Nonnull
    Resource getCheckboxFieldResource(@Nonnull Resource formResource, @Nonnull String label);

    /**
     * Returns a date field resource.
     *
     * @param formResource
     *            the form resource
     * @return a date field resource
     */
    @Nonnull
    Resource getDateFieldResource(@Nonnull Resource formResource);

    /**
     * Returns a default date resource.
     *
     * @param formResource
     *            the form resource
     * @return a default date resource
     */
    @Nonnull
    Resource getDefaultDateResource(@Nonnull Resource formResource);

    /**
     * Returns a default date resource.
     *
     * @param formResource
     *            the form resource
     * @param label
     *            the label
     * @return a default date resource
     */
    @Nonnull
    Resource getDefaultDateResource(@Nonnull Resource formResource, @Nonnull String label);

    /**
     * Returns a hidden field resource.
     *
     * @param formResource
     *            the form resource
     * @return a hidden field resource
     */
    @Nonnull
    Resource getHiddenFieldResource(@Nonnull Resource formResource);

    /**
     * Returns a default property field resource.
     *
     * @param formResource
     *            the form resource
     * @param values
     *            the values
     * @return a default property field resource
     */
    @Nonnull
    Resource getDefaultPropertyFieldResource(@Nonnull Resource formResource, @Nonnull HashMap<String, Object> values);

    /**
     * Returns the field template id used by external resources.
     *
     * @return the field template id used by external resources
     */
    @Nonnull
    String getFieldTemplateID();

    /**
     * Returns the dropdown option key used by external resources.
     *
     * @return the dropdown option key used by external resources
     */
    @Nonnull
    String getOptionTemplateID();

    /**
     * Returns the list order key used by external resources.
     *
     * @return the list order key used by external resources
     */
    @Nonnull
    String getOrderKey();
}
