/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa;

import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.trace.Trace;
import com.adobe.xfa.ut.trace.TraceHandler;


/**
 * @exclude from published api.
 */
class LogPseudoModel extends PseudoModel {

	private final AppModel moAppModel;

	
	public LogPseudoModel(AppModel oAppModel) {
		moAppModel = oAppModel;
		setClass("logPseudoModel");
	}

	public String getClassAtom() {
		return super.getClassName();
	}

	public ScriptTable getScriptTable() {
		return LogPseudoModelScript.moScriptTable;
	}

	public void message(int nNewResId, String sMessage, String sSeverity) {
		int eSeverity = LogMessage.MSG_INFORMATION;
		
		if (sSeverity.length() > 0) {
			switch (sSeverity.charAt(0)) {
			case 'w':
				eSeverity = LogMessage.MSG_WARNING;
				break;
			case 'f':
				eSeverity = LogMessage.MSG_FATAL_ERROR;
				break;
			case 't':
				eSeverity = LogMessage.MSG_TRACE;
				break;
			default: // let any others default to MSG_INFORMATION
				break;
			}
		}
		ExFull oMsg = new ExFull(nNewResId, sMessage);
		moAppModel.addErrorList(oMsg, eSeverity, null);
	}

	public void traceActivate(String sNamesAndLevels) {
		TraceHandler.getTraceHandler().activate(sNamesAndLevels);
	}

	public void traceDeactivate(String sName) {
		TraceHandler.getTraceHandler().deactivate(sName);
	}

	public void trace(String sName, int nLevel, int nId, String sMsg) {
		Trace.trace(sName, nLevel, nId, sMsg);
	}
	
	public boolean validateUsage(int nVersion, int nAvailability, boolean bUpdateVersion) {	
		if (moAppModel != null)
			return moAppModel.validateUsage(nVersion, nAvailability, bUpdateVersion);

		return super.validateUsage(nVersion, nAvailability, bUpdateVersion);
	}
	
	public boolean validateUsageFailedIsFatal(int nVersion, int nAvailability) {	
		if (moAppModel != null)
			return moAppModel.validateUsageFailedIsFatal(nVersion, nAvailability);

		return super.validateUsageFailedIsFatal(nVersion, nAvailability);
	}
	
	/**
	 * @see Obj#sendMessenge(ExFull, int)
	 * @exclude from published api.
	 */
	public void sendMessenge(ExFull error, int eSeverity) {
		if (moAppModel != null)
			moAppModel.addErrorList(error, eSeverity, null);
	}
}