/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.layout;


import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.gfx.GFXMappingList;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.font.GfxTextAttrs;
import com.adobe.xfa.ut.Rect;


/**
 *
 *  This class is ...
 *
 * @exclude from published api.
 */
public abstract class LayoutHandler {

	public LayoutHandler(Model oModel) {
		moModel = oModel;
	}

	public Model getModel() {
		return moModel;
	}

	public abstract void handleTextRun(Measurement left,
                                  Measurement top,
                                  Measurement width,
                                  Measurement height,
								  String oTextRun,
                                  FontInstance oFontInstance,
								  GfxTextAttrs oFontAtts);

	public abstract void handleGlyphRun(Measurement left,
                                   Measurement top,
                                   Measurement width,
                                   Measurement height,
								   int[] nGlyphs, 
								   int nSize,
                                   FontInstance oFontInstance,
								   GfxTextAttrs oFontAtts);

	public abstract void drawRect(Measurement left,
                             Measurement top,
                             Measurement width,
                             Measurement height,
                             Element oRectangle);

	public abstract void drawLine(Measurement oX,
							 Measurement oY,
							 Measurement oW,
							 Measurement oH,
							 Element oLine);

	public abstract void drawGraphic();

	public abstract void newPara();
	
	public abstract void setClipRect(Rect oRect);
	
	public void handleUnicodeChars(String text, int nSize)
	{
	}
	
	public void handleGlyphMapping(GFXMappingList mappingList, boolean bIsRTL)
	{
	}
	
    private Model moModel;

}
