/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.util;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.io.UnsupportedEncodingException;

public final class ByteOps {
    private static final boolean[] WS = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, true, true, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] REG = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, false, false, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true};
    private static final boolean[] LIT = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] DEC_DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] HEX_DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] OCT_DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] LEADING_OCT_DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final byte[] NUMERICAL_VALUE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] hexrep = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private ByteOps() {
    }

    public static final boolean isWhitespace(byte b) {
        return WS[b + 128];
    }

    public static final boolean isWhitespace(char c) {
        return c <= ' ' && WS[c + 128];
    }

    public static boolean isASCII(byte[] bytes) {
        for (int strInd = 0; strInd < bytes.length; ++strInd) {
            byte curByte = bytes[strInd];
            if (curByte >= 32 || ByteOps.isWhitespace(curByte)) continue;
            return false;
        }
        return true;
    }

    public static final byte[] xorArray(byte[] array, byte with) {
        byte[] result = new byte[array.length];
        for (int counter = 0; counter < array.length; ++counter) {
            result[counter] = (byte)(array[counter] ^ with);
        }
        return result;
    }

    private static int startsWithPartial(byte[] src, int srcOff, byte[] suffix, int sufOff) {
        int sufInd = -1;
        for (int count = srcOff; count < src.length && (sufInd = count - srcOff + sufOff) < suffix.length; ++count) {
            if (src[count] == suffix[sufInd]) continue;
            sufInd = -1;
            break;
        }
        return sufInd;
    }

    public static int endsWithPartial(byte[] src, int srcOff, byte[] suffix, int sufOff) {
        for (int count = srcOff; count < src.length; ++count) {
            if (ByteOps.startsWithPartial(src, count, suffix, sufOff) == -1) continue;
            return count;
        }
        return -1;
    }

    public static final int equalArrays(byte[] src, int srcOff, byte[] dst, int dstOff, int len) {
        if (src.length == 0 && dst.length == 0) {
            return -1;
        }
        if (src.length == 0 || dst.length == 0) {
            return 0;
        }
        for (int count = 0; count < len; ++count) {
            if (srcOff + count >= src.length) {
                return count;
            }
            if (dstOff + count >= dst.length) {
                return count;
            }
            if (src[srcOff + count] == dst[dstOff + count]) continue;
            return count;
        }
        return -1;
    }

    public static final int copy(byte[] src, int srcOff, byte[] dst, int dstOff, int len) {
        int retLen;
        int srcInd = srcOff;
        int destInd = dstOff;
        int count = retLen = Math.min(Math.min(src.length - srcOff, dst.length - dstOff), len);
        while (count-- > 0) {
            dst[destInd++] = src[srcInd++];
        }
        return retLen;
    }

    public static final byte[] splitInt2Bytes(int src, int count) {
        byte[] result = new byte[count];
        for (int index = 0; index < count; ++index) {
            result[index] = (byte)(src & 0xFF);
            src >>= 8;
        }
        return result;
    }

    public static final boolean isRegular(byte b) {
        return REG[b + 128];
    }

    public static final boolean isLiteral(byte b) {
        return LIT[b + 128];
    }

    public static final boolean isDigit(byte b) {
        return DEC_DIGIT[b + 128];
    }

    public static final boolean isHexDigit(byte b) {
        return HEX_DIGIT[b + 128];
    }

    public static final boolean isOctalDigit(byte b) {
        return OCT_DIGIT[b + 128];
    }

    public static final boolean isLeadingOctalDigit(byte b) {
        return LEADING_OCT_DIGIT[b + 128];
    }

    public static final byte getNumericalValue(byte b) {
        return NUMERICAL_VALUE[b + 128];
    }

    public static int readField(byte[] s, int pos) throws PDFParseException {
        if (pos + 1 >= s.length || !ByteOps.isDigit(s[pos]) || !ByteOps.isDigit(s[pos + 1])) {
            throw new PDFParseException(Integer.toString(pos));
        }
        return (s[pos] - 48) * 10 + (s[pos + 1] - 48);
    }

    public static byte[] getHex(byte[] src) {
        int j = 0;
        byte[] rslt = new byte[src.length * 2];
        for (int i = 0; i < src.length; ++i) {
            byte b = src[i];
            rslt[j++] = hexrep[b >> 4 & 0xF];
            rslt[j++] = hexrep[b & 0xF];
        }
        return rslt;
    }

    public static byte[] getHex(byte[] src, int size) {
        int j = 0;
        byte[] rslt = new byte[size];
        for (int i = 0; i < src.length; ++i) {
            byte b = src[i];
            rslt[j++] = hexrep[b >> 4 & 0xF];
            rslt[j++] = hexrep[b & 0xF];
        }
        return rslt;
    }

    public static String getHexString(byte[] in) {
        byte[] hex = ByteOps.getHex(in);
        try {
            return new String(hex, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ASCII encoding not supported.", e);
        }
    }

    public static ASName getHexName(byte[] in) throws UnsupportedEncodingException {
        return ByteOps.getHexName(in, false);
    }

    public static ASName getHexName(byte[] in, boolean uppercase) {
        String hex = ByteOps.getHexString(in);
        return ASName.create(uppercase ? hex.toUpperCase() : hex);
    }

    public static String getHexString(byte[] in, int size) throws UnsupportedEncodingException {
        byte[] hex = ByteOps.getHex(in, size);
        return new String(hex, "ASCII");
    }

    public static String getHexString2(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuilder out = new StringBuilder(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        return new String(out);
    }

    public static byte getHex(byte b) throws PDFParseException {
        int rslt = 0;
        if (b >= 48 && b <= 57) {
            rslt = b - 48;
        } else if (b >= 65 && b <= 70) {
            rslt = b - 65 + 10;
        } else if (b >= 97 && b <= 102) {
            rslt = b - 97 + 10;
        } else {
            throw new PDFParseException("Expected Hex Digit - instead got " + Byte.toString(b));
        }
        return (byte)rslt;
    }

    public static String getUnicode(byte[] unicodeBytes) {
        String encoding = "UTF-8";
        if (unicodeBytes == null || unicodeBytes.length <= 2) {
            return null;
        }
        if (unicodeBytes[0] == -2 && unicodeBytes[1] == -1 || unicodeBytes[0] == -1 && unicodeBytes[1] == -2) {
            encoding = "UTF-16";
        }
        try {
            return new String(unicodeBytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(encoding + " encoding not supported.", e);
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static final byte[] toByte(short word0) {
        byte[] abyte0 = new byte[2];
        for (int byte0 = 0; byte0 <= 1; byte0 = (int)((byte)(byte0 + 1))) {
            abyte0[byte0] = (byte)(word0 >>> (1 - byte0) * 8);
        }
        return abyte0;
    }
}

