/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.Manifest;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.NodeListFilter;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.form.FormDataListener;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormSubform;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Peer;
import com.adobe.xfa.ut.ResId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FormManifest
extends Manifest {
    protected static final IteratorAction<Boolean> validateFormNode = new IteratorAction<Boolean>(){

        @Override
        public Boolean action(Node item, Boolean data) {
            Boolean validateResult = data;
            assert (validateResult != null);
            if (validateResult != null) {
                if (item instanceof FormSubform) {
                    FormSubform formSubform = (FormSubform)item;
                    if (validateResult.booleanValue()) {
                        validateResult = formSubform.execValidate();
                    } else {
                        formSubform.execValidate();
                    }
                } else if (item instanceof FormField) {
                    FormField formField = (FormField)item;
                    if (validateResult.booleanValue()) {
                        validateResult = formField.execValidate();
                    } else {
                        formField.execValidate();
                    }
                } else if (item instanceof FormExclGroup) {
                    FormExclGroup exclGroup = (FormExclGroup)item;
                    if (validateResult.booleanValue()) {
                        validateResult = exclGroup.execValidate();
                    } else {
                        exclGroup.execValidate();
                    }
                }
            }
            return validateResult;
        }
    };
    protected static final IteratorAction<?> calculateFormNode = new IteratorAction<Object>(){

        @Override
        public Object action(Node item, Object data) {
            if (item instanceof FormSubform) {
                ((FormSubform)item).execEvent("calculate");
            } else if (item instanceof FormField) {
                ((FormField)item).execEvent("calculate");
            } else if (item instanceof FormExclGroup) {
                ((FormExclGroup)item).execEvent("calculate");
            }
            return null;
        }
    };
    protected static final IteratorAction<?> initializeFormNode = new IteratorAction<Object>(){

        @Override
        public Object action(Node item, Object data) {
            if (item instanceof FormSubform) {
                ((FormSubform)item).execEvent("initialize");
            } else if (item instanceof FormField) {
                ((FormField)item).execEvent("initialize");
            } else if (item instanceof FormExclGroup) {
                ((FormExclGroup)item).execEvent("initialize");
            }
            return null;
        }
    };
    protected static final IteratorAction<List<String>> populateFieldName = new IteratorAction<List<String>>(){

        @Override
        public List<String> action(Node item, List<String> aExcludedFields) {
            TemplateModel template = TemplateModel.getTemplateModel(item.getModel().getAppModel(), false);
            assert (template != null);
            if (template != null) {
                assert (aExcludedFields != null);
                if (aExcludedFields != null) {
                    assert (FormManifest.isTemplateField(item) || FormManifest.isTemplateExclGroup(item));
                    if (FormManifest.isTemplateField(item) || FormManifest.isTemplateExclGroup(item)) {
                        String sSOMExpression = item.getSOMExpression(template, false);
                        assert (sSOMExpression.length() > 0);
                        if (sSOMExpression.length() > 0) {
                            aExcludedFields.add(sSOMExpression);
                        }
                    }
                }
            }
            return null;
        }
    };

    FormManifest(Element parent, Node prevSibling) {
        super(parent, prevSibling);
    }

    @Override
    public boolean doExecValidate() {
        Boolean bValidateResult = Boolean.TRUE;
        Element parent = this.getXFAParent();
        assert (parent != null);
        if (parent != null) {
            if (parent.getClassTag() == 281) {
                bValidateResult = this.processPDFSignatureManifest(validateFormNode, bValidateResult);
            } else if (parent.getClassTag() == 280) {
                bValidateResult = this.processXMLSignatureManifest(validateFormNode, bValidateResult);
            } else {
                throw new ExFull(ResId.InvalidManifestException);
            }
        }
        return bValidateResult;
    }

    @Override
    public void doExecCalculate() {
        Element parent = this.getXFAParent();
        assert (parent != null);
        if (parent != null) {
            if (parent.getClassTag() == 281) {
                this.processPDFSignatureManifest(calculateFormNode, null);
            } else if (parent.getClassTag() == 280) {
                this.processXMLSignatureManifest(calculateFormNode, null);
            } else {
                throw new ExFull(ResId.InvalidManifestException);
            }
        }
    }

    @Override
    public void doExecInitialize() {
        Element parent = this.getXFAParent();
        assert (parent != null);
        if (parent != null) {
            if (parent.getClassTag() == 281) {
                this.processPDFSignatureManifest(initializeFormNode, null);
            } else if (parent.getClassTag() == 280) {
                this.processXMLSignatureManifest(initializeFormNode, null);
            } else {
                throw new ExFull(ResId.InvalidManifestException);
            }
        }
    }

    protected <T> T processPDFSignatureManifest(IteratorAction<T> iteratorAction, T data) {
        int eAction = this.getEnum(411);
        if (eAction == 0x6C0000) {
            return this.templateNodesToFormNodesInclude(iteratorAction, data);
        }
        if (eAction == 7077889) {
            return this.templateNodesToFormNodesExclude(iteratorAction, data);
        }
        if (eAction == 7077890) {
            return this.templateNodesToFormNodesAll(iteratorAction, data);
        }
        throw new ExFull(ResId.InvalidManifestException);
    }

    protected <T> T templateNodesToFormNodesInclude(IteratorAction<T> iteratorAction, T data) {
        NodeList referencedNodes = this.doEvaluate();
        assert (referencedNodes != null);
        if (referencedNodes == null) {
            return null;
        }
        int nNumReferencedNodes = referencedNodes.length();
        for (int nReferencedNodeIndex = 0; nReferencedNodeIndex < nNumReferencedNodes; ++nReferencedNodeIndex) {
            Obj referencedNode = referencedNodes.item(nReferencedNodeIndex);
            assert (referencedNode instanceof Node);
            if (!(referencedNode instanceof Node)) continue;
            List<Node> expandedNodes = this.expandResolvedNode((Node)referencedNode);
            int nNumExpandedNodes = expandedNodes.size();
            for (int nExpandedNodeIndex = 0; nExpandedNodeIndex < nNumExpandedNodes; ++nExpandedNodeIndex) {
                Node expandedNode = expandedNodes.get(nExpandedNodeIndex);
                data = this.templateNodeToFormNodes(iteratorAction, data, expandedNode);
            }
        }
        return data;
    }

    protected <T> T templateNodesToFormNodesExclude(IteratorAction<T> iteratorAction, T data) {
        TemplateModel template = TemplateModel.getTemplateModel(this.getAppModel(), false);
        assert (template != null);
        if (template != null) {
            ArrayList<String> aExcludedFields = new ArrayList<String>();
            this.templateNodeToTemplateNodes(populateFieldName, aExcludedFields);
            ManifestExclusionFilter filter = new ManifestExclusionFilter(aExcludedFields);
            List<Node> nodeList = filter.filterNodes(template);
            int nLength = nodeList.size();
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                Node node = nodeList.get(nIndex);
                data = this.templateNodeToFormNodes(iteratorAction, data, node);
            }
        }
        return data;
    }

    protected <T> T templateNodesToFormNodesAll(IteratorAction<T> iteratorAction, T data) {
        TemplateModel template = TemplateModel.getTemplateModel(this.getAppModel(), false);
        assert (template != null);
        if (template != null) {
            ManifestExclusionFilter filter = new ManifestExclusionFilter(null);
            List<Node> nodeList = filter.filterNodes(template);
            int nLength = nodeList.size();
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                Node node = nodeList.get(nIndex);
                data = this.templateNodeToFormNodes(iteratorAction, data, node);
            }
        }
        return data;
    }

    protected <T> T templateNodeToTemplateNodes(IteratorAction<T> iteratorAction, T data) {
        NodeList referencedNodes = this.doEvaluate();
        assert (referencedNodes != null);
        if (referencedNodes == null) {
            return data;
        }
        int nNumReferencedNodes = referencedNodes.length();
        for (int nReferencedNodeIndex = 0; nReferencedNodeIndex < nNumReferencedNodes; ++nReferencedNodeIndex) {
            Obj referencedNode = referencedNodes.item(nReferencedNodeIndex);
            assert (referencedNode instanceof Node);
            if (!(referencedNode instanceof Node)) continue;
            List<Node> expandedNodes = this.expandResolvedNode((Node)referencedNode);
            int nNumExpandedNodes = expandedNodes.size();
            for (int nExpandedNodeIndex = 0; nExpandedNodeIndex < nNumExpandedNodes; ++nExpandedNodeIndex) {
                Node expandedNode = expandedNodes.get(nExpandedNodeIndex);
                data = iteratorAction.action(expandedNode, data);
            }
        }
        return data;
    }

    protected <T> T templateNodeToFormNodes(IteratorAction<T> iteratorAction, T data, Node templateNode) {
        assert (templateNode != null && (FormManifest.isTemplateField(templateNode) || FormManifest.isTemplateExclGroup(templateNode)));
        ProtoableNode protoable = (ProtoableNode)templateNode;
        int nProtoedIndex = 0;
        ProtoableNode protoed = protoable.getProtoed(nProtoedIndex);
        while (protoed != null) {
            if (protoed.getModel() != null && (protoed instanceof FormField || protoed instanceof FormExclGroup)) {
                data = iteratorAction.action(protoed, data);
            }
            protoed = protoable.getProtoed(++nProtoedIndex);
        }
        return data;
    }

    protected List<Node> expandResolvedNode(Node item) {
        if (FormManifest.isTemplateField(item) || FormManifest.isTemplateExclGroup(item)) {
            return Collections.singletonList(item);
        }
        if (item instanceof Element) {
            ManifestExclusionFilter filter = new ManifestExclusionFilter(null);
            return filter.filterNodes(item, 0);
        }
        return Collections.emptyList();
    }

    protected static boolean isTemplateField(Node node) {
        return node instanceof Field && !(node instanceof FormField);
    }

    protected static boolean isTemplateExclGroup(Node node) {
        return node instanceof ExclGroup && !(node instanceof FormExclGroup);
    }

    protected <T> T processXMLSignatureManifest(IteratorAction<T> iteratorAction, T data) {
        int eAction = this.getEnum(411);
        if (eAction == 0x6C0000) {
            return this.dataNodesToFormNodesInclude(iteratorAction, data);
        }
        if (eAction == 7077889 || eAction == 7077890) {
            MsgFormatPos msg = new MsgFormatPos(ResId.UnsupportedOperationException);
            String sOpp = "action=\"" + EnumAttr.getString(eAction) + '\"';
            msg.format(sOpp);
            msg.format("manifest");
            throw new ExFull(msg);
        }
        throw new ExFull(ResId.InvalidManifestException);
    }

    protected <T> T dataNodesToFormNodesInclude(IteratorAction<T> iteratorAction, T data) {
        NodeList referencedNodes = this.doEvaluate();
        assert (referencedNodes != null);
        if (referencedNodes == null) {
            return data;
        }
        int nNumReferencedNodes = referencedNodes.length();
        for (int nReferencedNodeIndex = 0; nReferencedNodeIndex < nNumReferencedNodes; ++nReferencedNodeIndex) {
            Obj referencedNode = referencedNodes.item(nReferencedNodeIndex);
            assert (referencedNode instanceof Node);
            if (!(referencedNode instanceof Node)) continue;
            data = this.dataNodeToFormNodes(iteratorAction, data, (Node)referencedNode);
        }
        return data;
    }

    protected <T> T dataNodeToFormNodes(IteratorAction<T> iteratorAction, T data, Node dataNode) {
        assert (dataNode instanceof DataNode);
        if (dataNode instanceof DataNode) {
            int nPeerIndex = 0;
            Peer peer = dataNode.getPeer(nPeerIndex);
            while (peer != null) {
                Element formNode;
                if (peer instanceof FormDataListener && (formNode = ((FormDataListener)peer).getFormNode()) != null) {
                    data = iteratorAction.action(formNode, data);
                }
                peer = dataNode.getPeer(++nPeerIndex);
            }
        }
        return data;
    }

    protected static class ManifestExclusionFilter
    extends NodeListFilter {
        private final List<String> mExcludedFields;
        private Node mLastExclGroup;

        public ManifestExclusionFilter(List<String> excludedFields) {
            this.mExcludedFields = excludedFields;
        }

        @Override
        public boolean accept(Node node) {
            assert (node != null);
            if (node != null && (FormManifest.isTemplateField(node) || FormManifest.isTemplateExclGroup(node))) {
                this.mLastExclGroup = null;
                if (FormManifest.isTemplateField(node)) {
                    if (node.getXFAParent() == this.mLastExclGroup) {
                        return false;
                    }
                } else {
                    this.mLastExclGroup = node;
                }
                if (this.mExcludedFields == null) {
                    return true;
                }
                String sSOMExpression = node.getSOMExpression(node.getModel(), false);
                return !this.mExcludedFields.contains(sSOMExpression);
            }
            return false;
        }
    }

    protected static interface IteratorAction<T> {
        public T action(Node var1, T var2);
    }
}

