/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.AFERun;
import com.adobe.xfa.text.DispLine;
import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.DispMap;
import com.adobe.xfa.text.DispMapItem;
import com.adobe.xfa.text.DispRun;
import com.adobe.xfa.text.GlyphLoc;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextCharProp;

class MappingManager {
    private final ExplicitRunProcessor mExplicitRunProcessor = new ExplicitRunProcessor();
    private DispLine mLine;
    private int mCharCount;
    private byte[] mLevels;
    private int[] mDirections;

    MappingManager() {
    }

    void analyze(DispLine line) {
        this.mLine = line;
        this.mCharCount = line.getCharCount();
        if (this.mCharCount == 0) {
            return;
        }
        if (!this.mLine.hasBIDI()) {
            return;
        }
        if (this.mDirections == null || this.mDirections.length < this.mCharCount) {
            this.mDirections = new int[this.mCharCount];
            this.mLevels = new byte[this.mCharCount];
        }
        this.mExplicitRunProcessor.setup(this.mLine, this.mDirections, this.mLevels);
        this.mExplicitRunProcessor.run();
        WeakTypeResolver weakResolver = new WeakTypeResolver();
        weakResolver.execute();
        NeutralTypeResolver neutralResolver = new NeutralTypeResolver();
        neutralResolver.execute();
        for (int i = 0; i < this.mCharCount; ++i) {
            byte level = this.mLevels[i];
            int direction = this.mDirections[i];
            int defaultDirection = MappingManager.getDirectionFromLevel(level);
            int add = 0;
            switch (direction) {
                case 262144: 
                case 0x140000: {
                    if (defaultDirection == 0x380000) {
                        add = 1;
                        break;
                    }
                    add = 2;
                    break;
                }
                case 0x200000: {
                    if (defaultDirection != 0x380000) break;
                    add = 1;
                    break;
                }
                case 0x380000: {
                    if (defaultDirection != 0x200000) break;
                    add = 1;
                }
            }
            this.mLevels[i] = (byte)(level + add);
        }
    }

    void applyToWrappedLine(DispLineWrapped wrappedLine, AFERun afeRun, int start) {
        int i;
        int length = wrappedLine.getCharCount();
        if (length <= 0) {
            return;
        }
        int limit = start + length;
        DispMap glyphLocMap = this.mLine.getGlyphLocMap();
        int glyphLocCount = glyphLocMap.size();
        if (glyphLocCount == 0) {
            glyphLocMap = null;
        }
        int[] indexes = null;
        if (this.mLine.hasBIDI()) {
            int maxLevel = this.resetTrailingSpaces(start, limit, afeRun);
            indexes = this.reorderRuns(start, limit, maxLevel);
        }
        boolean[] visited = new boolean[length];
        for (i = 0; i < length; ++i) {
            visited[i] = false;
        }
        int glyphIndex = 0;
        GlyphLoc glyphLoc = new GlyphLoc();
        for (i = 0; i < length; ++i) {
            int rawIndex = indexes == null ? i + start : indexes[i];
            int visitedIndex = rawIndex - start;
            assert (visitedIndex >= 0 && visitedIndex < length);
            if (visited[visitedIndex]) continue;
            int glyphLocIndex = rawIndex;
            int glyphLocLimit = rawIndex + 1;
            if (glyphLocMap != null) {
                int foundIndex = glyphLocMap.findItem(rawIndex);
                boolean charPresent = false;
                if (glyphLocMap.isValidMapIndex(foundIndex)) {
                    DispMapItem testGlyphLoc = glyphLocMap.getItem(foundIndex);
                    int charStart = testGlyphLoc.getMapIndex();
                    int charLimit = charStart + testGlyphLoc.getMapLength();
                    if (charStart <= rawIndex && rawIndex < charLimit) {
                        charPresent = true;
                    }
                }
                if (charPresent) {
                    glyphLocIndex = foundIndex;
                    int referenceIndex = this.mLine.getGlyphLoc(foundIndex).getMapIndex();
                    int testIndex = foundIndex;
                    while (testIndex > 0 && glyphLocMap.getItem(--testIndex).getMapIndex() == referenceIndex) {
                        glyphLocIndex = testIndex;
                    }
                    testIndex = glyphLocLimit = foundIndex + 1;
                    while (testIndex < glyphLocCount && glyphLocMap.getItem(testIndex).getMapIndex() == referenceIndex) {
                        glyphLocLimit = testIndex++;
                    }
                } else {
                    glyphLocLimit = glyphLocIndex;
                }
            }
            while (glyphLocIndex < glyphLocLimit) {
                glyphLoc.copyFrom(this.mLine.getGlyphLoc(glyphLocIndex));
                int wrappedIndex = glyphLoc.getMapIndex() - start;
                assert (wrappedIndex >= 0);
                for (int j = 0; j < glyphLoc.getMapLength(); ++j) {
                    int index = wrappedIndex + j;
                    assert (index < length);
                    visited[index] = true;
                }
                glyphLoc.setGlyphIndex(glyphIndex);
                wrappedLine.add(glyphLoc, wrappedIndex, glyphLoc.getMapLength());
                ++glyphIndex;
                ++glyphLocIndex;
            }
        }
    }

    int getLevel(int index) {
        return this.mLevels[index];
    }

    private int resetTrailingSpaces(int start, int limit, AFERun afeRun) {
        byte maxLevel = 0;
        byte defaultLevel = (byte)this.getDefaultLevel();
        boolean defaultWhitespaceLevels = true;
        int i = limit;
        while (i > 0) {
            int type;
            if ((type = TextCharProp.getBIDIClass(this.mLine.getBreakData(--i))) == 0x480000 && this.mLine.tabAt(i) != null) {
                type = 0x440000;
            }
            switch (type) {
                case 524288: 
                case 0x440000: {
                    this.overrideLevel(i, defaultLevel, afeRun);
                    defaultWhitespaceLevels = true;
                    break;
                }
                case 0x480000: {
                    if (!defaultWhitespaceLevels) break;
                    this.overrideLevel(i, defaultLevel, afeRun);
                    break;
                }
                default: {
                    if (MappingManager.isExplicitControl(type)) break;
                    defaultWhitespaceLevels = false;
                }
            }
            if (this.mLevels[i] <= maxLevel) continue;
            maxLevel = this.mLevels[i];
        }
        return maxLevel;
    }

    private int[] reorderRuns(int start, int limit, int maxLevel) {
        int i;
        int length = limit - start;
        if (length <= 0) {
            return null;
        }
        int[] indexes = new int[length];
        for (i = 0; i < length; ++i) {
            indexes[i] = i + start;
        }
        while (maxLevel > 0) {
            int runStart = -1;
            for (i = 0; i < length; ++i) {
                if (this.mLevels[i + start] >= maxLevel) {
                    if (runStart >= 0) continue;
                    runStart = i;
                    continue;
                }
                if (runStart < 0) continue;
                MappingManager.reverseRun(indexes, runStart, i);
                runStart = -1;
            }
            if (runStart >= 0) {
                MappingManager.reverseRun(indexes, runStart, length);
            }
            --maxLevel;
        }
        int accentRunStart = -1;
        for (i = 0; i < length; ++i) {
            int index = indexes[i];
            int breakType = this.mLine.getBreakClass(index);
            if (breakType == 8) {
                if (accentRunStart >= 0) continue;
                accentRunStart = i;
                continue;
            }
            if (accentRunStart >= 0 && MappingManager.isRTL(this.mLevels[index])) {
                MappingManager.reverseRun(indexes, accentRunStart, i + 1);
            }
            accentRunStart = -1;
        }
        return indexes;
    }

    private void overrideLevel(int index, byte newLevel, AFERun afeRun) {
        this.mLevels[index] = newLevel;
        afeRun.getElement(index).setBIDILevel(newLevel);
    }

    private static boolean isRTL(int level) {
        return (level & 1) != 0;
    }

    private static int getDirectionFromLevel(int level) {
        return MappingManager.isRTL(level) ? 0x380000 : 0x200000;
    }

    private static int nextEvenLevel(int level) {
        return MappingManager.isRTL(level) ? level + 1 : level + 2;
    }

    private static int nextOddLevel(int level) {
        return MappingManager.isRTL(level) ? level + 2 : level + 1;
    }

    private int getDefaultLevel() {
        return this.mLine.isRTL() ? 1 : 0;
    }

    private static int resolveDirection(int override, int direction) {
        return override == 0x300000 ? direction : override;
    }

    private static boolean isStrong(int direction) {
        switch (direction) {
            case 0: 
            case 0x200000: 
            case 0x240000: 
            case 0x280000: 
            case 0x380000: 
            case 0x3C0000: 
            case 0x400000: {
                return true;
            }
        }
        return false;
    }

    private static boolean isExplicitControl(int direction) {
        switch (direction) {
            case 0x240000: 
            case 0x280000: 
            case 0x340000: 
            case 0x3C0000: 
            case 0x400000: {
                return true;
            }
        }
        return false;
    }

    private final int findNonExplicit(int index, int limit) {
        while (index < limit && MappingManager.isExplicitControl(this.mDirections[index])) {
            ++index;
        }
        return index;
    }

    private static void reverseRun(int[] indexes, int start, int limit) {
        int mid = (start + limit) / 2;
        int end = limit - 1;
        while (start < mid) {
            int swap = indexes[start];
            indexes[start] = indexes[end];
            indexes[end] = swap;
            ++start;
            --end;
        }
    }

    private class NeutralTypeResolver
    extends LevelRunProcessor {
        private int mRunDirection;
        private int mPrevStrongDirection;
        private int mNextStrongDirection;
        private int mFirstNeutralIndex;
        private int mNextIndex;
        private boolean mFirstTime;

        NeutralTypeResolver() {
            this.mFirstNeutralIndex = -1;
            this.mFirstTime = true;
        }

        @Override
        int processChar(int index, int prevDirection, int direction, int nextDirection) {
            if (this.mFirstTime) {
                this.mRunDirection = MappingManager.getDirectionFromLevel(this.getDirection(index));
                this.mPrevStrongDirection = prevDirection;
                this.mFirstTime = false;
            }
            int strongDir = 0x300000;
            switch (direction) {
                case 0: 
                case 262144: 
                case 0x140000: 
                case 0x380000: {
                    strongDir = 0x380000;
                    break;
                }
                case 0x200000: {
                    strongDir = 0x200000;
                    break;
                }
                case 524288: 
                case 0x300000: 
                case 0x440000: 
                case 0x480000: {
                    if (this.mFirstNeutralIndex >= 0) break;
                    this.mFirstNeutralIndex = index;
                }
            }
            if (strongDir != 0x300000) {
                this.flushRun(index, strongDir);
                this.mPrevStrongDirection = strongDir;
            }
            this.mNextStrongDirection = nextDirection;
            this.mNextIndex = index + 1;
            return -1;
        }

        @Override
        void finishRun() {
            this.flushRun(this.mNextIndex, this.mNextStrongDirection);
        }

        private final void flushRun(int limit, int direction) {
            if (this.mFirstNeutralIndex >= 0) {
                int neutralDir = direction == this.mPrevStrongDirection ? direction : this.mRunDirection;
                this.setDirection(this.mFirstNeutralIndex, limit, neutralDir);
                this.mFirstNeutralIndex = -1;
            }
        }
    }

    private class WeakTypeResolver
    extends LevelRunProcessor {
        private int mPrevStrong;
        private int mETRunStart;

        WeakTypeResolver() {
        }

        @Override
        int processChar(int index, int prevDirection, int direction, int nextDirection) {
            int prevOverride = -1;
            boolean preserveETRun = false;
            switch (direction) {
                case 0x2C0000: {
                    this.setDirection(index, prevDirection);
                    break;
                }
                case 0x140000: {
                    if (this.mPrevStrong == 0) {
                        this.setDirection(index, 262144);
                    } else {
                        int newDirection = this.resolveENDirection(this.mPrevStrong);
                        this.setDirection(index, newDirection);
                        this.setDirection(this.mETRunStart, index, newDirection);
                    }
                    prevOverride = 0x140000;
                    break;
                }
                case 0: {
                    this.setDirection(index, 0x380000);
                    break;
                }
                case 0x180000: {
                    if (prevDirection == 0x140000 && nextDirection == 0x140000) {
                        this.setDirection(index, this.resolveENDirection(this.mPrevStrong));
                        break;
                    }
                    this.setDirection(index, 0x300000);
                    break;
                }
                case 0x100000: {
                    boolean usePrev = false;
                    if (prevDirection == nextDirection) {
                        switch (prevDirection) {
                            case 262144: 
                            case 0x140000: {
                                usePrev = true;
                            }
                        }
                    }
                    if (usePrev) {
                        this.setDirection(index, prevDirection);
                        break;
                    }
                    this.setDirection(index, 0x300000);
                    break;
                }
                case 0x1C0000: {
                    if (prevDirection == 0x140000) {
                        this.setDirection(index, this.resolveENDirection(this.mPrevStrong));
                        prevOverride = 0x140000;
                        break;
                    }
                    preserveETRun = true;
                    if (this.mETRunStart >= 0) break;
                    this.mETRunStart = index;
                    break;
                }
                default: {
                    if (!MappingManager.isStrong(direction)) break;
                    this.mPrevStrong = direction;
                }
            }
            if (!preserveETRun) {
                this.mETRunStart = -1;
            }
            return prevOverride;
        }
    }

    private abstract class LevelRunProcessor {
        LevelRunProcessor() {
        }

        void execute() {
            int i = 0;
            while (i < MappingManager.this.mCharCount) {
                int runStart = i;
                byte sorLevel = MappingManager.this.mLevels[i];
                if (i > 0 && MappingManager.this.mLevels[i - 1] > sorLevel) {
                    sorLevel = MappingManager.this.mLevels[i - 1];
                }
                ++i;
                byte eorLevel = sorLevel;
                while (i < MappingManager.this.mCharCount) {
                    byte nextLevel = MappingManager.this.mLevels[i];
                    if (nextLevel != eorLevel) {
                        if (nextLevel <= eorLevel) break;
                        eorLevel = nextLevel;
                        break;
                    }
                    ++i;
                }
                int runLimit = i;
                this.processRun(runStart, runLimit, sorLevel, eorLevel);
            }
        }

        abstract int processChar(int var1, int var2, int var3, int var4);

        void finishRun() {
        }

        final int resolveENDirection(int prevStrong) {
            return prevStrong == 0x200000 ? 0x200000 : 0x140000;
        }

        final int getDirection(int index) {
            return MappingManager.this.mDirections[index];
        }

        final void setDirection(int index, int direction) {
            ((MappingManager)MappingManager.this).mDirections[index] = direction;
        }

        final void setDirection(int start, int limit, int direction) {
            if (start >= 0) {
                int i = start;
                while (i < limit) {
                    this.setDirection(i, direction);
                    i = MappingManager.this.findNonExplicit(i + 1, limit);
                }
            }
        }

        private void processRun(int runStart, int runLimit, int sorLevel, int eorLevel) {
            int index = MappingManager.this.findNonExplicit(runStart, runLimit);
            if (index >= runLimit) {
                return;
            }
            int direction = MappingManager.this.mDirections[index];
            int prevDirection = MappingManager.getDirectionFromLevel(sorLevel);
            while (index < runLimit) {
                int nextIndex = MappingManager.this.findNonExplicit(index + 1, runLimit);
                int nextDirection = nextIndex < runLimit ? MappingManager.this.mDirections[nextIndex] : MappingManager.getDirectionFromLevel(eorLevel);
                int prevOverride = this.processChar(index, prevDirection, direction, nextDirection);
                prevDirection = prevOverride == -1 ? MappingManager.this.mDirections[index] : prevOverride;
                direction = nextDirection;
                index = nextIndex;
            }
            this.finishRun();
        }
    }

    private static class ExplicitRunProcessor {
        private DispLine mLine;
        private int mCharCount;
        private int[] mDirections;
        private byte[] mLevels;
        private boolean mDefaultRTL;
        private int mDefaultEmbedding;
        private int mRunIndex;
        private int mRunLimit;

        private ExplicitRunProcessor() {
        }

        void setup(DispLine line, int[] directions, byte[] levels) {
            this.mLine = line;
            this.mCharCount = this.mLine.getCharCount();
            this.mDirections = directions;
            this.mLevels = levels;
            this.mDefaultRTL = this.mLine.isRTL();
            this.mDefaultEmbedding = this.mDefaultRTL ? 0x3C0000 : 0x240000;
            this.mRunIndex = 0;
            this.mRunLimit = 0;
            byte defaultLevel = (byte)(this.mDefaultRTL ? 1 : 0);
            for (int i = 0; i < this.mCharCount; ++i) {
                this.mDirections[i] = line.getBreakData(i);
                this.mLevels[i] = defaultLevel;
            }
        }

        void run() {
            this.processExplicitRun(0, this.mDefaultEmbedding, this.mDefaultRTL ? 1 : 0, 0x300000);
        }

        private int processExplicitRun(int index, int dispRunDir, int level, int override) {
            boolean atInitialDepth;
            boolean bl = atInitialDepth = index == 0;
            while (index < this.mLine.getCharCount()) {
                if (index >= this.mRunLimit) {
                    ++this.mRunIndex;
                    if (this.mRunIndex >= this.mLine.getRunCount()) {
                        this.mRunLimit = this.mLine.getCharCount();
                    } else {
                        DispRun run = this.mLine.getRun(this.mRunIndex);
                        this.mRunLimit = run.getMapIndex() + run.getMapLength();
                        TextAttr textAttr = run.getAttr();
                        if (textAttr != null) {
                            int newDispRunDir;
                            switch (textAttr.direction()) {
                                case 1: {
                                    newDispRunDir = 0x240000;
                                    break;
                                }
                                case 2: {
                                    newDispRunDir = 0x3C0000;
                                    break;
                                }
                                default: {
                                    newDispRunDir = this.mDefaultEmbedding;
                                }
                            }
                            if (newDispRunDir != dispRunDir) {
                                if (newDispRunDir == this.mDefaultEmbedding) {
                                    return index;
                                }
                                int newLevel = newDispRunDir == 0x240000 ? MappingManager.nextEvenLevel(level) : MappingManager.nextOddLevel(level);
                                if ((index = this.processExplicitRun(index, newDispRunDir, newLevel, override)) >= this.mCharCount) {
                                    return index;
                                }
                            }
                        }
                    }
                }
                int charData = this.mLine.getBreakData(index);
                int direction = TextCharProp.getBIDIClass(charData);
                int newLevel = level;
                int newOverride = override;
                switch (direction) {
                    case 0x240000: {
                        newLevel = MappingManager.nextEvenLevel(level);
                        newOverride = 0x300000;
                        break;
                    }
                    case 0x280000: {
                        newLevel = MappingManager.nextEvenLevel(level);
                        newOverride = 0x200000;
                        break;
                    }
                    case 0x3C0000: {
                        newLevel = MappingManager.nextOddLevel(level);
                        newOverride = 0x300000;
                        break;
                    }
                    case 0x400000: {
                        newLevel = MappingManager.nextOddLevel(level);
                        newOverride = 0x380000;
                        break;
                    }
                    case 0x340000: {
                        if (atInitialDepth) break;
                        this.mLevels[index] = (byte)level;
                        this.mDirections[index] = MappingManager.resolveDirection(override, direction);
                        return index + 1;
                    }
                }
                if (newLevel != level && newLevel > 61) {
                    newLevel = level;
                    newOverride = override;
                }
                this.mLevels[index] = (byte)newLevel;
                this.mDirections[index] = MappingManager.resolveDirection(newOverride, direction);
                if (newLevel == level) {
                    ++index;
                    continue;
                }
                if ((index = this.processExplicitRun(index + 1, dispRunDir, newLevel, newOverride)) < this.mCharCount) continue;
                return index;
            }
            return index;
        }
    }
}

