/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.Asset;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public class StockUtil {
    public static final String STOCK_ROOT_PATH = "/libs/dam/stock/asset";
    public static final String STOCK_STATE_UNLICENSED = "Unlicensed";
    public static final String PN_STOCK_ID = "stock:id";
    public static final String PN_STOCK_LICENSE = "stock:license";
    public static final String PN_STOCK_IS_EDITORIAL = "stock:isEditorial";

    public static boolean isStockAsset(Resource res) {
        if (res == null) {
            return false;
        }
        Asset asset = res.adaptTo(Asset.class);
        return asset != null && StringUtils.isNotEmpty(asset.getMetadataValue(PN_STOCK_ID));
    }

    public static boolean isStockAssetLicensed(Resource res) {
        if (StockUtil.isStockAsset(res)) {
            String license = res.adaptTo(Asset.class).getMetadataValue(PN_STOCK_LICENSE);
            return StringUtils.isNotEmpty(license) && !license.equals(STOCK_STATE_UNLICENSED);
        }
        return false;
    }

    public static boolean isStockAssetEditorial(Resource res) {
        if (StockUtil.isStockAsset(res)) {
            String isEditorialValue = res.adaptTo(Asset.class).getMetadataValue(PN_STOCK_IS_EDITORIAL);
            return Boolean.valueOf(isEditorialValue);
        }
        return false;
    }

    public static boolean isStockAccessible(ResourceResolver resourceResolver) {
        return !ResourceUtil.isNonExistingResource(resourceResolver.resolve(STOCK_ROOT_PATH));
    }
}

