/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.PredicateGroupEvaluator;
import javax.jcr.Session;
import javax.jcr.query.Row;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, factory="com.day.cq.search.eval.PredicateEvaluator/savedquery")
public class SavedQueryPredicate
extends PredicateGroupEvaluator {
    private static final Logger log = LoggerFactory.getLogger(SavedQueryPredicate.class);
    public static final String SAVED_QUERY = "savedquery";
    @Reference
    public QueryBuilder queryBuilder;

    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        PredicateGroup group = this.getSavedPredicates(p, context);
        if (group != null) {
            return super.getXPathExpression(group, context);
        }
        return null;
    }

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        PredicateGroup group = this.getSavedPredicates(p, context);
        if (group != null) {
            return super.includes(group, row, context);
        }
        return true;
    }

    @Override
    public boolean canXpath(Predicate p, EvaluationContext context) {
        PredicateGroup group = this.getSavedPredicates(p, context);
        if (group != null) {
            return super.canXpath(group, context);
        }
        return false;
    }

    @Override
    public boolean canFilter(Predicate p, EvaluationContext context) {
        PredicateGroup group = this.getSavedPredicates(p, context);
        if (group != null) {
            return super.canFilter(group, context);
        }
        return false;
    }

    protected String getEvalContextKey(Predicate p) {
        return p.getPath() + ".savedquery";
    }

    protected PredicateGroup getSavedPredicates(Predicate p, EvaluationContext context) {
        if (!p.hasNonEmptyValue(SAVED_QUERY)) {
            return null;
        }
        String key = this.getEvalContextKey(p);
        PredicateGroup group = null;
        Object obj = context.get(key);
        if (obj == null) {
            group = this.loadPredicates(p.get(SAVED_QUERY), context.getSession());
            if (group == null) {
                context.put(key, new Object());
            } else {
                context.put(key, group);
            }
        } else if (obj instanceof PredicateGroup) {
            group = (PredicateGroup)obj;
        }
        return group;
    }

    protected PredicateGroup loadPredicates(String path, Session session) {
        try {
            Query query = this.queryBuilder.loadQuery(path, session);
            if (query == null) {
                log.warn("No saved query found at '" + path + "'");
                return null;
            }
            return query.getPredicates();
        }
        catch (Exception e) {
            log.error("Could not load query from '" + path + "'", e);
            return null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }
}

