/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.model.responsivegrid;

import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.cq.wcm.foundation.model.responsivegrid.Breakpoint;
import com.day.cq.wcm.foundation.model.responsivegrid.ResponsiveGridUtils;
import com.day.cq.wcm.foundation.model.responsivegrid.export.ResponsiveColumnExporter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.factory.ModelFactory;
import org.osgi.annotation.versioning.ProviderType;

@JsonSerialize(as=ResponsiveColumnExporter.class)
@ProviderType
public class ResponsiveColumn
extends AbstractResource
implements ResponsiveColumnExporter {
    private final Resource wrappedResource;
    private final String classNames;
    private final Map<String, Breakpoint> breakpoints;
    private final String columnCssClassPrefix;
    private ComponentExporter componentModel;
    private SlingHttpServletRequest slingRequest;
    private ModelFactory modelFactory;

    public ResponsiveColumn(Resource resource, Map<String, Breakpoint> gridBreakpoints, String classNamePrefix) {
        this.columnCssClassPrefix = classNamePrefix + "Column";
        this.wrappedResource = resource;
        Map<String, Breakpoint> generatedBreakpoints = this.getBreakpoints(this.wrappedResource, gridBreakpoints);
        Map<String, Breakpoint> missingBreakpoints = ResponsiveGridUtils.getMissingBreakpoints(generatedBreakpoints, gridBreakpoints);
        this.breakpoints = this.combineBreakpointMaps(generatedBreakpoints, missingBreakpoints);
        this.classNames = ResponsiveGridUtils.createClassNames(this.columnCssClassPrefix + " " + this.getComponentClasses(resource), this.breakpoints, this::generateBreakpointCssClasses);
    }

    public ResponsiveColumn(Resource resource, Map<String, Breakpoint> gridBreakpoints, String classNamePrefix, SlingHttpServletRequest slingRequest, ModelFactory modelFactory) {
        this(resource, gridBreakpoints, classNamePrefix);
        this.slingRequest = slingRequest;
        this.modelFactory = modelFactory;
    }

    Map<String, Breakpoint> getBreakpoints(Resource resource, Map<String, Breakpoint> referenceBreakpoints) {
        if (resource == null) {
            return Collections.emptyMap();
        }
        Resource responsiveCfg = resource.getChild("cq:responsive");
        HashMap<String, Breakpoint> breakpointMap = new HashMap<String, Breakpoint>();
        if (responsiveCfg != null) {
            Iterator<Resource> resCfgIt = responsiveCfg.listChildren();
            while (resCfgIt.hasNext()) {
                Breakpoint gridBreakpoint;
                Resource resCfg = resCfgIt.next();
                String breakpointName = resCfg.getName();
                ValueMap cfg = resCfg.getValueMap();
                int width = cfg.get("width", 12);
                int offset = cfg.get("offset", 0);
                Breakpoint.ResponsiveBehavior behavior = Breakpoint.ResponsiveBehavior.valueOf(cfg.get("behavior", Breakpoint.ResponsiveBehavior.none.toString()));
                Breakpoint breakpoint = gridBreakpoint = referenceBreakpoints != null ? referenceBreakpoints.get(breakpointName) : null;
                if (gridBreakpoint != null && width + offset > gridBreakpoint.getWidth()) {
                    if (width > gridBreakpoint.getWidth()) {
                        width = gridBreakpoint.getWidth();
                        offset = 0;
                    } else if (offset < gridBreakpoint.getWidth()) {
                        width = gridBreakpoint.getWidth() - offset;
                    } else {
                        offset = 0;
                    }
                }
                breakpointMap.put(breakpointName, new Breakpoint(breakpointName, width, offset, behavior));
            }
        }
        return breakpointMap;
    }

    Map<String, Breakpoint> combineBreakpointMaps(Map<String, Breakpoint> columnBreakpoints, Map<String, Breakpoint> missingBreakpoints) {
        HashMap<String, Breakpoint> breakpoints = new HashMap<String, Breakpoint>();
        breakpoints.put("default", new Breakpoint("default", 12, 0, null));
        breakpoints.putAll(missingBreakpoints);
        breakpoints.putAll(columnBreakpoints);
        return breakpoints;
    }

    String getComponentClasses(Resource resource) {
        String cssClass = "";
        Component component = WCMUtils.getComponent(resource);
        if (component == null) {
            return cssClass;
        }
        ValueMap componentProperties = component.getProperties();
        if (componentProperties != null) {
            cssClass = componentProperties.get("cq:cssClass", "");
        }
        return cssClass;
    }

    List<String> generateBreakpointCssClasses(Breakpoint breakpoint) {
        String breakpointName = breakpoint.getName();
        int offset = breakpoint.getOffset();
        int width = breakpoint.getWidth();
        Breakpoint.ResponsiveBehavior behavior = breakpoint.getResponsiveBehavior();
        ArrayList<String> breakpointClasses = new ArrayList<String>();
        if (width > 0) {
            String widthBreakpointClassname = ResponsiveGridUtils.createClassname(Arrays.asList(this.columnCssClassPrefix, breakpointName, Integer.toString(width)));
            breakpointClasses.add(widthBreakpointClassname);
        }
        if (offset > -1) {
            String offsetBreakpointClassname = ResponsiveGridUtils.createClassname(Arrays.asList(this.columnCssClassPrefix, "offset", breakpointName, Integer.toString(offset)));
            breakpointClasses.add(offsetBreakpointClassname);
        }
        if (behavior != null) {
            String behaviorBreakpointClassname = ResponsiveGridUtils.createClassname(Arrays.asList(this.columnCssClassPrefix, breakpointName, behavior.toString()));
            breakpointClasses.add(behaviorBreakpointClassname);
        }
        return breakpointClasses;
    }

    @Override
    public Map<String, Breakpoint> getBreakpoints() {
        return this.breakpoints;
    }

    @Override
    public String getColumnClassNames() {
        return this.classNames;
    }

    @Override
    @Nonnull
    public ComponentExporter getExportedComponent() {
        if (this.componentModel == null) {
            this.componentModel = this.modelFactory.getModelFromWrappedRequest(this.slingRequest, this.wrappedResource, ComponentExporter.class);
        }
        return this.componentModel;
    }

    @Override
    @Nonnull
    public String getExportedType() {
        return this.wrappedResource.getResourceType();
    }

    @Nonnull
    public Resource getResource() {
        return this.wrappedResource;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.wrappedResource.getPath();
    }

    @Deprecated
    public String getCssClass() {
        return this.classNames;
    }

    @Deprecated
    public Set<String> getMissingBreakpointNames() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Integer getColumnCount(String breakpointName) {
        return this.breakpoints.get(breakpointName).getWidth();
    }

    @Override
    @Nonnull
    @Deprecated
    public String getResourceType() {
        return this.wrappedResource.getResourceType();
    }

    @Override
    @Deprecated
    public String getResourceSuperType() {
        return this.wrappedResource.getResourceSuperType();
    }

    @Override
    @Nonnull
    @Deprecated
    public ResourceMetadata getResourceMetadata() {
        return this.wrappedResource.getResourceMetadata();
    }

    @Override
    @Nonnull
    @Deprecated
    public ResourceResolver getResourceResolver() {
        return this.wrappedResource.getResourceResolver();
    }

    @Deprecated
    public ValueMap getProperties() {
        return this.wrappedResource.adaptTo(ValueMap.class);
    }
}

