/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.model.responsivegrid;

import com.day.cq.wcm.foundation.model.responsivegrid.Breakpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ResponsiveGridUtils {
    static String createClassname(List<String> classNameIngredients) {
        return String.join((CharSequence)"--", classNameIngredients);
    }

    static String createClassNames(String initial, Map<String, Breakpoint> breakpoints, Function<Breakpoint, List<String>> generator) {
        if (breakpoints == null) {
            breakpoints = Collections.emptyMap();
        }
        String cssClass = initial;
        String cssClasses = breakpoints.values().stream().map(generator).flatMap(Collection::stream).collect(Collectors.joining(" "));
        cssClass = cssClass + " " + cssClasses;
        return cssClass.replaceAll("\\s{2,}", " ").trim();
    }

    static Map<String, Breakpoint> getMissingBreakpoints(Map<String, Breakpoint> breakpoints, Set<String> missingBreakpointNames) {
        missingBreakpointNames.removeAll(breakpoints.keySet());
        HashMap<String, Breakpoint> referenceBreakpoints = new HashMap<String, Breakpoint>();
        for (String missingBreakpoint : missingBreakpointNames) {
            referenceBreakpoints.put(missingBreakpoint, null);
        }
        return ResponsiveGridUtils.getMissingBreakpoints(breakpoints, referenceBreakpoints);
    }

    static Map<String, Breakpoint> getMissingBreakpoints(Map<String, Breakpoint> breakpoints, Map<String, Breakpoint> referenceBreakpoints) {
        if (referenceBreakpoints == null || referenceBreakpoints.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Breakpoint> missingBreakpoints = new HashMap<String, Breakpoint>();
        ArrayList<String> missingGridBreakpointNames = new ArrayList<String>(referenceBreakpoints.keySet());
        missingGridBreakpointNames.removeAll(breakpoints.keySet());
        Breakpoint defaultBreakpoint = breakpoints.get("default");
        for (String missingGridBreakpointName : missingGridBreakpointNames) {
            Breakpoint gridBreakPointVariant;
            int width = 0;
            int offset = 0;
            int gridWidth = 0;
            if (defaultBreakpoint != null) {
                width = defaultBreakpoint.getWidth();
                offset = defaultBreakpoint.getOffset();
            }
            if ((gridBreakPointVariant = referenceBreakpoints.get(missingGridBreakpointName)) != null) {
                gridWidth = gridBreakPointVariant.getWidth();
            }
            if (width == 0 || width + offset > gridWidth) {
                width = gridWidth;
                offset = 0;
            }
            if (width == 0 || width > 12) {
                width = 12;
            }
            if (offset == 0) {
                offset = -1;
            }
            missingBreakpoints.put(missingGridBreakpointName, new Breakpoint(missingGridBreakpointName, width, offset, null));
        }
        return missingBreakpoints;
    }
}

