/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol;

import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.jcr.PartialValueFactory;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ACE
implements JackrabbitAccessControlEntry {
    private final Principal principal;
    private final PrivilegeBits privilegeBits;
    private final boolean isAllow;
    private final Set<Restriction> restrictions;
    private final NamePathMapper namePathMapper;
    private final PartialValueFactory valueFactory;
    private int hashCode;

    public ACE(@Nullable Principal principal, @Nullable PrivilegeBits privilegeBits, boolean isAllow, @Nullable Set<Restriction> restrictions, @NotNull NamePathMapper namePathMapper) throws AccessControlException {
        if (principal == null || privilegeBits == null || privilegeBits.isEmpty()) {
            throw new AccessControlException();
        }
        this.principal = principal;
        this.privilegeBits = privilegeBits;
        this.isAllow = isAllow;
        this.restrictions = restrictions == null ? Collections.emptySet() : ImmutableSet.copyOf(restrictions);
        this.namePathMapper = namePathMapper;
        this.valueFactory = new PartialValueFactory(namePathMapper);
    }

    @NotNull
    public PrivilegeBits getPrivilegeBits() {
        return this.privilegeBits;
    }

    @NotNull
    public Set<Restriction> getRestrictions() {
        return this.restrictions;
    }

    @Override
    @NotNull
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public boolean isAllow() {
        return this.isAllow;
    }

    @Override
    @NotNull
    public String[] getRestrictionNames() {
        return Collections2.transform(this.restrictions, this::getJcrName).toArray(new String[this.restrictions.size()]);
    }

    @Override
    @Nullable
    public Value getRestriction(@NotNull String restrictionName) throws RepositoryException {
        for (Restriction restriction : this.restrictions) {
            String jcrName = this.getJcrName(restriction);
            if (!jcrName.equals(restrictionName)) continue;
            if (restriction.getDefinition().getRequiredType().isArray()) {
                List<Value> values = this.valueFactory.createValues(restriction.getProperty());
                if (values.size() == 1) {
                    return values.get(0);
                }
                throw new ValueFormatException("Attempt to retrieve single value from multivalued property");
            }
            return this.valueFactory.createValue(restriction.getProperty());
        }
        return null;
    }

    @Override
    @Nullable
    public Value[] getRestrictions(@NotNull String restrictionName) {
        for (Restriction restriction : this.restrictions) {
            String jcrName = this.getJcrName(restriction);
            if (!jcrName.equals(restrictionName)) continue;
            List<Value> values = this.valueFactory.createValues(restriction.getProperty());
            return values.toArray(new Value[0]);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hashCode(this.principal.getName(), this.privilegeBits, this.isAllow, this.restrictions);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ACE) {
            ACE other = (ACE)obj;
            return this.principal.getName().equals(other.principal.getName()) && this.isAllow == other.isAllow && this.privilegeBits.equals(other.privilegeBits) && this.restrictions.equals(other.restrictions);
        }
        return false;
    }

    private String getJcrName(Restriction restriction) {
        return this.namePathMapper.getJcrName(restriction.getDefinition().getName());
    }
}

