/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@Deprecated(since="2021-05-27")
class MetaData {
    private static final Logger LOG = Log.getLogger(MetaData.class);
    private static final MBeanAttributeInfo[] NO_ATTRIBUTES = new MBeanAttributeInfo[0];
    private static final MBeanConstructorInfo[] NO_CONSTRUCTORS = new MBeanConstructorInfo[0];
    private static final MBeanOperationInfo[] NO_OPERATIONS = new MBeanOperationInfo[0];
    private static final MBeanNotificationInfo[] NO_NOTIFICATIONS = new MBeanNotificationInfo[0];
    private final Map<String, AttributeInfo> _attributes = new HashMap<String, AttributeInfo>();
    private final Map<String, OperationInfo> _operations = new HashMap<String, OperationInfo>();
    private final Class<?> _klass;
    private final MetaData _parent;
    private final List<MetaData> _interfaces;
    private final Constructor<?> _constructor;
    private final MBeanInfo _info;

    MetaData(Class<?> klass, Constructor<?> constructor, MetaData parent, List<MetaData> interfaces) {
        this._klass = klass;
        this._parent = parent;
        this._interfaces = interfaces;
        this._constructor = constructor;
        if (this._constructor != null) {
            this.parseMethods(klass, this._constructor.getDeclaringClass());
        } else {
            this.parseMethods(klass);
        }
        this._info = this.buildMBeanInfo(klass);
    }

    Object newInstance(Object bean) {
        Object mbean = this._constructor != null ? MetaData.newInstance(this._constructor, bean) : (this._parent != null ? this._parent.newInstance(bean) : new ObjectMBean(bean));
        return mbean;
    }

    MBeanInfo getMBeanInfo() {
        return this._info;
    }

    Object getAttribute(String name, ObjectMBean mbean) throws AttributeNotFoundException, ReflectionException, MBeanException {
        AttributeInfo info = this.findAttribute(name);
        if (info == null) {
            throw new AttributeNotFoundException(name);
        }
        return info.getAttribute(mbean);
    }

    void setAttribute(Attribute attribute, ObjectMBean mbean) throws AttributeNotFoundException, ReflectionException, MBeanException {
        if (attribute == null) {
            return;
        }
        String name = attribute.getName();
        AttributeInfo info = this.findAttribute(name);
        if (info == null) {
            throw new AttributeNotFoundException(name);
        }
        info.setAttribute(attribute.getValue(), mbean);
    }

    private AttributeInfo findAttribute(String name) {
        AttributeInfo r;
        if (name == null) {
            return null;
        }
        AttributeInfo result = null;
        for (MetaData intf : this._interfaces) {
            AttributeInfo r2 = intf.findAttribute(name);
            if (r2 == null) continue;
            result = r2;
        }
        if (this._parent != null && (r = this._parent.findAttribute(name)) != null) {
            result = r;
        }
        if ((r = this._attributes.get(name)) != null) {
            result = r;
        }
        return result;
    }

    Object invoke(String name, String[] params, Object[] args, ObjectMBean mbean) throws ReflectionException, MBeanException {
        String signature = MetaData.signature(name, params);
        OperationInfo info = this.findOperation(signature);
        if (info == null) {
            throw new ReflectionException(new NoSuchMethodException(signature));
        }
        return info.invoke(args, mbean);
    }

    private OperationInfo findOperation(String signature) {
        OperationInfo r;
        OperationInfo result = null;
        for (MetaData intf : this._interfaces) {
            OperationInfo r2 = intf.findOperation(signature);
            if (r2 == null) continue;
            result = r2;
        }
        if (this._parent != null && (r = this._parent.findOperation(signature)) != null) {
            result = r;
        }
        if ((r = this._operations.get(signature)) != null) {
            result = r;
        }
        return result;
    }

    private static Object newInstance(Constructor<?> constructor, Object bean) {
        try {
            Object mbean;
            Object obj = mbean = constructor.getParameterCount() == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(bean);
            if (mbean instanceof ModelMBean) {
                ((ModelMBean)mbean).setManagedResource(bean, "objectReference");
            }
            return mbean;
        }
        catch (Throwable x) {
            return null;
        }
    }

    private void parseMethods(Class<?> ... classes) {
        for (Class<?> klass : classes) {
            for (Method method : klass.getDeclaredMethods()) {
                ManagedOperation operation;
                if (!Modifier.isPublic(method.getModifiers())) continue;
                ManagedAttribute attribute = method.getAnnotation(ManagedAttribute.class);
                if (attribute != null) {
                    AttributeInfo info = new AttributeInfo(attribute, method);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found attribute {} for {}: {}", info._name, klass.getName(), info);
                    }
                    this._attributes.put(info._name, info);
                }
                if ((operation = method.getAnnotation(ManagedOperation.class)) == null) continue;
                OperationInfo info = new OperationInfo(operation, method);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found operation {} for {}: {}", info._name, klass.getName(), info);
                }
                this._operations.put(info._name, info);
            }
        }
    }

    static String toAttributeName(String methodName) {
        String attributeName = methodName;
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            attributeName = attributeName.substring(3);
        } else if (methodName.startsWith("is")) {
            attributeName = attributeName.substring(2);
        }
        return attributeName.substring(0, 1).toLowerCase(Locale.ENGLISH) + attributeName.substring(1);
    }

    private static boolean isManagedObject(Class<?> klass) {
        if (klass.isArray()) {
            klass = klass.getComponentType();
        }
        if (klass.isPrimitive()) {
            return false;
        }
        while (klass != null) {
            if (klass.isAnnotationPresent(ManagedObject.class)) {
                return true;
            }
            klass = klass.getSuperclass();
        }
        return false;
    }

    private static String signature(String name, String[] params) {
        return String.format("%s(%s)", name, String.join((CharSequence)",", params));
    }

    private static String signature(Method method) {
        String signature = Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(","));
        return String.format("%s(%s)", method.getName(), signature);
    }

    private MBeanInfo buildMBeanInfo(Class<?> klass) {
        ManagedObject managedObject = klass.getAnnotation(ManagedObject.class);
        String description = managedObject == null ? "" : managedObject.value();
        HashMap<String, MBeanAttributeInfo> attributeInfos = new HashMap<String, MBeanAttributeInfo>();
        this.collectMBeanAttributeInfos(attributeInfos);
        HashMap<String, MBeanOperationInfo> operationInfos = new HashMap<String, MBeanOperationInfo>();
        this.collectMBeanOperationInfos(operationInfos);
        MBeanInfo mbeanInfo = this._parent == null ? null : this._parent.getMBeanInfo();
        MBeanAttributeInfo[] attributes = attributeInfos.values().toArray(NO_ATTRIBUTES);
        MBeanConstructorInfo[] constructors = mbeanInfo == null ? NO_CONSTRUCTORS : mbeanInfo.getConstructors();
        MBeanOperationInfo[] operations = operationInfos.values().toArray(NO_OPERATIONS);
        MBeanNotificationInfo[] notifications = mbeanInfo == null ? NO_NOTIFICATIONS : mbeanInfo.getNotifications();
        return new MBeanInfo(klass.getName(), description, attributes, constructors, operations, notifications);
    }

    private void collectMBeanAttributeInfos(Map<String, MBeanAttributeInfo> attributeInfos) {
        for (MetaData metaData : this._interfaces) {
            metaData.collectMBeanAttributeInfos(attributeInfos);
        }
        if (this._parent != null) {
            MBeanAttributeInfo[] parentAttributes;
            for (MBeanAttributeInfo parentAttribute : parentAttributes = this._parent.getMBeanInfo().getAttributes()) {
                attributeInfos.put(parentAttribute.getName(), parentAttribute);
            }
        }
        for (Map.Entry entry : this._attributes.entrySet()) {
            attributeInfos.put((String)entry.getKey(), ((AttributeInfo)entry.getValue())._info);
        }
    }

    private void collectMBeanOperationInfos(Map<String, MBeanOperationInfo> operationInfos) {
        for (MetaData metaData : this._interfaces) {
            metaData.collectMBeanOperationInfos(operationInfos);
        }
        if (this._parent != null) {
            MBeanOperationInfo[] parentOperations;
            for (MBeanOperationInfo parentOperation : parentOperations = this._parent.getMBeanInfo().getOperations()) {
                String signature = MetaData.signature(parentOperation.getName(), (String[])Arrays.stream(parentOperation.getSignature()).map(MBeanParameterInfo::getType).toArray(String[]::new));
                operationInfos.put(signature, parentOperation);
            }
        }
        for (Map.Entry entry : this._operations.entrySet()) {
            operationInfos.put((String)entry.getKey(), ((OperationInfo)entry.getValue())._info);
        }
    }

    private static MBeanException toMBeanException(InvocationTargetException x) {
        Throwable cause = x.getCause();
        if (cause instanceof Exception) {
            return new MBeanException((Exception)cause);
        }
        return new MBeanException(x);
    }

    public String toString() {
        return String.format("%s@%x[%s, attrs=%s, opers=%s]", this.getClass().getSimpleName(), this.hashCode(), this._klass.getName(), this._attributes.keySet(), this._operations.keySet());
    }

    @Deprecated(since="2021-05-27")
    private static class OperationInfo {
        private final String _name;
        private final Method _method;
        private final boolean _proxied;
        private final boolean _convert;
        private final MBeanOperationInfo _info;

        private OperationInfo(ManagedOperation operation, Method method) {
            this._name = MetaData.signature(method);
            this._method = method;
            this._proxied = operation.proxied();
            Class<?> returnType = method.getReturnType();
            this._convert = MetaData.isManagedObject(returnType);
            String returnSignature = this._convert ? (returnType.isArray() ? ObjectName[].class.getName() : ObjectName.class.getName()) : returnType.getName();
            String impactName = operation.impact();
            int impact = 3;
            if ("ACTION".equals(impactName)) {
                impact = 1;
            } else if ("INFO".equals(impactName)) {
                impact = 0;
            } else if ("ACTION_INFO".equals(impactName)) {
                impact = 2;
            }
            String description = operation.value();
            MBeanParameterInfo[] parameterInfos = OperationInfo.parameters(method.getParameterTypes(), method.getParameterAnnotations());
            this._info = new MBeanOperationInfo(method.getName(), description, parameterInfos, returnSignature, impact);
        }

        public Object invoke(Object[] args, ObjectMBean mbean) throws ReflectionException, MBeanException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("invoke {}.{}({}) {}", mbean, this._info.getName(), Arrays.asList(args), this._info);
            }
            try {
                Object result;
                Object target = mbean.getManagedObject();
                if (this._proxied || this._method.getDeclaringClass().isInstance(mbean)) {
                    target = mbean;
                }
                if ((result = this._method.invoke(target, args)) == null) {
                    return null;
                }
                if (!this._convert) {
                    return result;
                }
                if (!this._method.getReturnType().isArray()) {
                    return mbean.findObjectName(result);
                }
                int length = Array.getLength(result);
                ObjectName[] names = new ObjectName[length];
                for (int i = 0; i < length; ++i) {
                    names[i] = mbean.findObjectName(Array.get(result, i));
                }
                return names;
            }
            catch (InvocationTargetException x) {
                throw MetaData.toMBeanException(x);
            }
            catch (Exception x) {
                throw new ReflectionException(x);
            }
        }

        private static MBeanParameterInfo[] parameters(Class<?>[] parameterTypes, Annotation[][] parametersAnnotations) {
            MBeanParameterInfo[] result = new MBeanParameterInfo[parameterTypes.length];
            for (int i = 0; i < parametersAnnotations.length; ++i) {
                Annotation[] parameterAnnotations;
                MBeanParameterInfo info = null;
                String typeName = parameterTypes[i].getName();
                for (Annotation parameterAnnotation : parameterAnnotations = parametersAnnotations[i]) {
                    if (!(parameterAnnotation instanceof Name)) continue;
                    Name name = (Name)parameterAnnotation;
                    info = result[i] = new MBeanParameterInfo(name.value(), typeName, name.description());
                    break;
                }
                if (info != null) continue;
                result[i] = new MBeanParameterInfo("p" + i, typeName, "");
            }
            return result;
        }

        public String toString() {
            return String.format("%s@%x[%s,proxied=%b,convert=%b]", this.getClass().getSimpleName(), this.hashCode(), this._name, this._proxied, this._convert);
        }
    }

    @Deprecated(since="2021-05-27")
    private static class AttributeInfo {
        private final String _name;
        private final Method _getter;
        private final Method _setter;
        private final boolean _proxied;
        private final boolean _convert;
        private final MBeanAttributeInfo _info;

        private AttributeInfo(ManagedAttribute attribute, Method getter) {
            String name = attribute.name();
            if ("".equals(name)) {
                name = MetaData.toAttributeName(getter.getName());
            }
            this._name = name;
            this._getter = getter;
            boolean readOnly = attribute.readonly();
            this._setter = readOnly ? null : this.findSetter(attribute, getter, name);
            this._proxied = attribute.proxied();
            Class<?> returnType = getter.getReturnType();
            this._convert = MetaData.isManagedObject(returnType);
            String signature = this._convert ? (returnType.isArray() ? ObjectName[].class.getName() : ObjectName.class.getName()) : returnType.getName();
            String description = attribute.value();
            this._info = new MBeanAttributeInfo(name, signature, description, true, this._setter != null, getter.getName().startsWith("is"));
        }

        Object getAttribute(ObjectMBean mbean) throws ReflectionException, MBeanException {
            try {
                Object result;
                Object target = mbean.getManagedObject();
                if (this._proxied || this._getter.getDeclaringClass().isInstance(mbean)) {
                    target = mbean;
                }
                if ((result = this._getter.invoke(target, new Object[0])) == null) {
                    return null;
                }
                if (!this._convert) {
                    return result;
                }
                if (!this._getter.getReturnType().isArray()) {
                    return mbean.findObjectName(result);
                }
                int length = Array.getLength(result);
                ObjectName[] names = new ObjectName[length];
                for (int i = 0; i < length; ++i) {
                    names[i] = mbean.findObjectName(Array.get(result, i));
                }
                return names;
            }
            catch (InvocationTargetException x) {
                throw MetaData.toMBeanException(x);
            }
            catch (Exception x) {
                throw new ReflectionException(x);
            }
        }

        void setAttribute(Object value, ObjectMBean mbean) throws ReflectionException, MBeanException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("setAttribute {}.{}={} {}", mbean, this._info.getName(), value, this._info);
            }
            try {
                if (this._setter == null) {
                    return;
                }
                Object target = mbean.getManagedObject();
                if (this._proxied || this._setter.getDeclaringClass().isInstance(mbean)) {
                    target = mbean;
                }
                if (!this._convert || value == null) {
                    this._setter.invoke(target, value);
                    return;
                }
                if (!this._getter.getReturnType().isArray()) {
                    value = mbean.findBean((ObjectName)value);
                    this._setter.invoke(target, value);
                    return;
                }
                ObjectName[] names = (ObjectName[])value;
                Object[] result = new Object[names.length];
                for (int i = 0; i < names.length; ++i) {
                    Array.set(result, i, mbean.findBean(names[i]));
                }
                this._setter.invoke(target, new Object[]{result});
            }
            catch (InvocationTargetException x) {
                throw MetaData.toMBeanException(x);
            }
            catch (Exception x) {
                throw new ReflectionException(x);
            }
        }

        private Method findSetter(ManagedAttribute attribute, Method getter, String name) {
            String setterName = attribute.setter();
            if ("".equals(setterName)) {
                setterName = "set" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
            }
            Method setter = null;
            Class<?> klass = getter.getDeclaringClass();
            for (Method method : klass.getMethods()) {
                if (!method.getName().equals(setterName) || method.getParameterCount() != 1) continue;
                if (setter != null) {
                    LOG.info("Multiple setters for mbean attribute {} in {}", name, klass);
                    continue;
                }
                if (!getter.getReturnType().equals(method.getParameterTypes()[0])) {
                    LOG.info("Getter/setter type mismatch for mbean attribute {} in {}", name, klass);
                    continue;
                }
                setter = method;
            }
            return setter;
        }

        public String toString() {
            return String.format("%s@%x[%s,proxied=%b,convert=%b,info=%s]", this.getClass().getSimpleName(), this.hashCode(), this._name, this._proxied, this._convert, this._info);
        }
    }
}

