/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.cq.dam.mac.sync.api;

import aQute.bnd.annotation.ProviderType;

/**
 * DAM Sync Agent Configuration. Defines the properties of a DAM Sync Agent.
 */
@ProviderType
public interface SyncAgent {
    /**
     * Returns the name of the sync agent
     * @return
     */
    public String getName();

    /**
     * Returns the type of the sync agent
     * @return
     */
    public String getType();

    /**
     * Returns the HTTP Method for the sync agent
     * @return
     */
    public String getProtocolHTTPMethod();

    /**
     * Returns the <code>sling:ResourceType</code> property of the sync agent
     * @return
     */
    public String getSlingResourceType();

    /**
     * Returns the <code>cq:Template</code> property of the sync agent
     * @return
     */
    public String getCqTemplate();

    /**
     * Provides a suitable name for a replication agent used for the bi-directional synchronisation.
     *
     * @param tenant the tenant's ID
     * @return the agent's name
     */
    public String getAgentNameForTenant(String tenant) ;
}
