/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.experiencelog;

import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.annotation.versioning.ProviderType;

/**
 * Provides information about the experience log configuration.
 */
@ProviderType
public interface ExperienceLogConfig {

    /**
     * Returns {@code true} if experience log functionality is enabled or
     * {@code false} otherwise.
     *
     * @param request
     *            {@link SlingHttpServletRequest}
     * @return {@code true} if the tracking is enabled for the given request,
     *         {@code false} otherwise
     */
    boolean isEnabled(SlingHttpServletRequest request);

    /**
     * Returns the URL of the tracking script used to log the experience.
     *
     * @return the URL of the tracking script.
     */
    String getTrackingScript();
}
