/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.wcm.style;

import javax.annotation.Nullable;

import org.osgi.annotation.versioning.ProviderType;

/**
 * A {@code StyleInfo} provides methods for retrieving style information.
 * It represents a style resource defined in a content policy below a {@code cq:styles} node.
 *
 * @since com.adobe.cq.wcm.style 1.0.0
 */
@ProviderType
public interface StyleInfo {

    /**
     * Retrieves the style ID.
     *
     * @return the unique style ID if it exists, {@code null} otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nullable
    String getId();

    /**
     * Retrieves the readable name of the style.
     *
     * @return the readable name of the style if it exists, {@code null} otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nullable
    String getLabel();

    /**
     * Retrieves the CSS style classes defined as a string for the style.
     *
     * @return the CSS style classes string if it exists, {@code null} otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nullable
    String getCssClasses();

    /**
     * Retrieves the HTML element defined for the style.
     *
     * @return the HTML element if it exists, {@code null} otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nullable
    String getHtmlElement();
}