/*
 * File: Gasp.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font.opentype;

import java.util.Map;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray.OTByteArrayBuilder;

/** Gives access to the 'gasp' table.
 * 
 * <h4>Version handling</h4>
 * 
 * <p>'gasp' tables have only a minor version number.
 * This implementation:
 * <ul> 
 * <li>fully supports version 0 tables,</li>
 * <li>interprets version x > 0  tables as version 0 tables,</li>
 * </ul> 
 * 
 * <p>When some data is not present in the actual version of the table,
 * the accessors return identified values.</p>
 * 
 * 
 * <h4>Synchronization</h4>
 * 
 * <p>Like all tables, these objects are immutable.</p> 
 */

public final class Gasp extends Table {
  /*
   * Bit selectors for the flags returned by getBehavior ()
   */
  public interface BehaviorBits {
    public static final int GRIDFIT      = 0x0001;
    public static final int GRAYSCALE    = 0x0002;
  }
 
  protected Gasp (FontByteArray buffer) 
  throws java.io.IOException, InvalidFontException, UnsupportedFontException {
    super (buffer);
  }

  /** Return the behavior for a given ppem **/
  public int getBehavior (double ppem) throws InvalidFontException {
    int numRanges = data.getuint16 (2);
    int offset = 4;
    while (numRanges > 0) {
      int maxPPEM = data.getuint16 (offset);
      if (ppem <= maxPPEM) {
        return data.getuint16(offset + 2); }
      offset += 4; }
    return 0;
  }
  
  public void subsetAndStream (Subset subset, Map tables) {
    OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance(this.data);
    tables.put (new Integer (Tag.table_gasp), newData); 
  }
}
