/*
 * File: OTSelectorAtLigatureLevel.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.fontengine.inlineformatting.LigatureLevel;

final public class OTSelectorAtLigatureLevel extends OTSelector {
  private final LigatureLevel level;
  
  public OTSelectorAtLigatureLevel (LigatureLevel level) {
    this.level = level;
  }

  /* @see com.adobe.fontengine.font.opentype.OTSelector#isApplied(com.adobe.fontengine.inlineformatting.AttributedRun, int)
   */
  public boolean isApplied (AttributedRun run, int position) {
    LigatureLevel allowedLigLevel = (LigatureLevel) run.getInterElementStyleBefore (position, InterElementAttribute.ligatureLevel);
    if (!LigatureLevel.lessThanOrEqual (level, allowedLigLevel)) {
      return false; }
    return true;
  }
  
  /* @see com.adobe.fontengine.font.opentype.OTSelector#isApplied(com.adobe.fontengine.inlineformatting.AttributedRun, int, int)
   */
  public boolean isApplied (AttributedRun run, int from, int to) {
    for (int i = from + 1; i <= to; i++) {
      LigatureLevel allowedLigLevel = (LigatureLevel) run.getInterElementStyleBefore (i, InterElementAttribute.ligatureLevel);
      if (!LigatureLevel.lessThanOrEqual (level, allowedLigLevel)) {
        return false; }}
    return true;
  }
  
  /* @see com.adobe.fontengine.font.opentype.OTSelector#isApplied(com.adobe.fontengine.inlineformatting.AttributedRun, int[])
   */
  public boolean isApplied (AttributedRun run, int[] positions) {
    for (int i = positions [0] + 1; i <= positions [positions.length -1]; i++) {
      LigatureLevel allowedLigLevel = (LigatureLevel) run.getInterElementStyleBefore (i, InterElementAttribute.ligatureLevel);
      if (! LigatureLevel.lessThanOrEqual (level, allowedLigLevel)) {
        return false; }}    
    return true;
  }
}
