/*
 * File: CacheSupportInfo.java
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2009 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.fontmanagement;

import java.io.Serializable;

/**
 * Additional font info items, above and beyond any particular FontDescription, which may
 * be used in support of the font cache to avoid unnecessary font parsing operations.
 * Immutable and therefore thread safe.
 */
public class CacheSupportInfo implements Serializable {
	static final long serialVersionUID = 1;

	private final String mFontType;
	private final int mNumGlyphs;
	private final boolean mIsCFF;

	public CacheSupportInfo(String type, int numGlyphs, boolean cff)
	{
		mFontType = type;
		mNumGlyphs = numGlyphs;
		mIsCFF = cff;
	}

	public String getFontType()
	{
		return mFontType;
	}

	public int getNumGlyphs()
	{
		return mNumGlyphs;
	}

	public boolean isCFF()
	{
		return mIsCFF;
	}
	
	public String toString()
	{
		return ("Font type = " + mFontType + ", Num glyphs = " + mNumGlyphs + ", isCFF = " + mIsCFF);
	}
}
