/*
 * File: PDFSimpleFontValuesAccessor.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute.CSSStretchValue;

abstract public class PDFSimpleFontValuesAccessor {
  /** Access to a PDF simple /Font.
   * 
   * <p>This class provides access to the values of various keys of
   * a PDF object with /Type /Font and a simple font /Subtype, as well
   * as of its associated /FontDescriptor.
   */
  
  /** The /FontFamily of the /FontDescriptor. */
  abstract public String getFontFamily () throws InvalidFontException, UnsupportedFontException;
  
  /** The Postscript name of the font. 
   * This should be the full font Postscript name, not the subset Postscript name. */
  abstract public String getPostscriptName () throws InvalidFontException, UnsupportedFontException;
  
  /** The /FontBBox of the /FontDescriptor. */
  abstract public Rect getFontBBox () throws InvalidFontException, UnsupportedFontException;
  
  /** The /Flag of the /FontDescriptor. */
  abstract public int getFlags () throws InvalidFontException, UnsupportedFontException;
  
  /** The /CapHeight of the /FontDescriptor. */
  abstract public double getCapHeight () throws InvalidFontException, UnsupportedFontException;
  
  /** The /XHeight of the /FontDescriptor */
  abstract public double getXHeight() throws InvalidFontException, UnsupportedFontException;
  
  /** The /Ascent of the /FontDescriptor. */
  abstract public double getAscent () throws InvalidFontException, UnsupportedFontException;
  
  /** The /Descent of the /FontDescriptor. */
  abstract public double getDescent () throws InvalidFontException, UnsupportedFontException;
  
  /** The /Leading of the /FontDescriptor. */
  abstract public double getLeading () throws InvalidFontException, UnsupportedFontException;

  /** The /StemV of the /FontDescriptor. */
  abstract public double getStemV () throws InvalidFontException, UnsupportedFontException;

  /** The /ItalicAngle of the /FontDescriptor. */
  abstract public double getItalicAngle () throws InvalidFontException, UnsupportedFontException;
  
  /** The /FontStretch of the /FontDescriptor. */
  abstract public CSSStretchValue getFontStretch () throws InvalidFontException, UnsupportedFontException;
  
  /** The /FontWeight of the /FontDescriptor. */
  abstract public int getFontWeight () throws InvalidFontException, UnsupportedFontException;
  
   

  /** The name of a glyph. Called if the font is non-symbolic. */
  abstract public String getGlyphName (int characterCode) throws InvalidFontException, UnsupportedFontException;
  
  /** The advance width of a glyph. */
  abstract public double getGlyphWidth (int characterCode) throws InvalidFontException, UnsupportedFontException;
}

