package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;

public class TamilFormatter  extends IndicFormatter {

  protected int splitVowelsAndNormalize (AttributedRun run, int start, int limit) {
     while (start < limit) {
      int usv = run.elementAt (start);
      switch (usv) {
        case 0x0BCA: {
          run.replace (start, new int[] {0x0BC6, 0x0BBE});
          limit++; 
          start += 2;
          break; }
        case 0x0BCB: {
          run.replace (start, new int[] {0x0BC7, 0x0BBE});
          limit++; 
          start += 2;
          break; }
        case 0x0BCC: {
          run.replace (start, new int[] {0x0BC6, 0x0BD7});
          limit++; 
          start += 2;
          break; }
        default: {
          start++; 
          break; }}}

   return limit;
  }

  protected int nukta () {
    return 0x0ABC;
  }

  protected int virama () {
    return 0xACD;
  }

  protected boolean isConsonant (int usv) {
    return (   0xB95 <= usv && usv <= 0xBB9
            || 0x25cc == usv);
  }

  protected boolean hasNukta (int usv) {
    return false;
  }

  protected int removeNukta (int usv) {
    return usv;
  }

  protected boolean isMark (int usv) {
    return (   0x0BBE <= usv && usv <= 0x0BCC
            || 0x0BD7 <= usv && usv <= 0xBD7);
  }

  protected boolean isIndependentVowel (int usv) {
    return (   0x0B85 <= usv && usv <= 0x0B94
            || 0x25cc == usv);
  }

  protected Position getPosition (int usv) {
    switch (usv) {
      case 0xBC6: 
      case 0xBC7:
      case 0xBC8: return Position.left;
      
      case 0xBC0: return Position.topMatra;
      
      case 0xB82: return Position.topOther;
      
      case 0xBC1:
      case 0xBC2: return Position.bottom;
          
      case 0xBBE:
      case 0xBBF: return Position.rightMatra;
      
      case 0xBD7: return Position.rightOther;
      
      default:    return Position.any; }
  }
  
  protected Shape rephLike (int usv) {
    return Shape.any;
  }

  protected boolean subjoins (int usv) {
    return (false);
  }
  
  protected boolean postjoins (int usv) {
    return false;
  }
  
  protected boolean postjoinsIndependentVowels (int usv) {
    return false;
  }
}