/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.oauth.server;

import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The <code>OAuth2ResourceServer</code> provides a simple API to
 * handle scopes and resources of an OAuth Resource Server  as defined in
 * http://tools.ietf.org/html/rfc6749
 *
 */
@ProviderType
public interface OAuth2ResourceServer {

    /**
     * Get a Map of the scopes allowed by an OAuth resource server.
     * The map entry key is the scope name and the map entry value is the corresponding {@link Scope} instance.
     *
     * @return The Map of the scopes allowed by an OAuth resource server
     */
    public Map<String,Scope> getAllowedScopes();

    /**
     * Get an instance of a Scope defined by the scope name.
     * @param name The name of the Scope
     * @return An instance of Scope
     */
    public Scope getScope(String name);
}
