/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.workflow.job;

import com.adobe.granite.workflow.exec.WorkItem;
import org.apache.sling.event.EventUtil;
import org.osgi.service.event.Event;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;

/**
 * The <code>WorkflowJob</code> class provides a utility for creating event
 * triggered job used for programmed/scripted workflow steps.
 */
public class WorkflowJob implements Serializable {
    /**
     * Generated serial version UID.
     */
    private static final long serialVersionUID = 5670996916430565635L;

    /**
     * The job topic for adding an entry to the audit log.
     */
    public static final String JOB_TOPIC = "com/adobe/granite/workflow/job";

    public static final String JOB_TOPIC_WC = "com/adobe/granite/workflow/job/*";

    /**
     * The event property holding the {@link WorkflowJob}.
     */
    public static final String WORKFLOW_JOB = "com.adobe.granite.workflow.job";

    public static final String WORKFLOW_JOB_ID = "com.adobe.granite.workflow.jobid";

    /**
     * The serialized {@link WorkItem} {@link Map} of the job.
     */
    protected Map item;

    /**
     * Creates a new WorkflowJob.
     * @param item the work item
     */
    public WorkflowJob(Map item) {
        if (item == null) {
            throw new IllegalArgumentException("Resource must not be null.");
        }
        this.item = item;
    }

    /**
     * Returns the {@link WorkItem} {@link Map} of the job
     * @return the {@link WorkItem} {@link Map} of the job
     */
    public Map getWorkItemMap() {
        return item;
    }

    /**
     * Convenience method to create a job event for the workflow job.
     * @param retryCount the retryCount
     * @param numOfParallelProcs the number of parallel processes
     * @param jobId the workflow job id
     * @return the created job event
     */
    public Event createJobEvent(Integer retryCount, int numOfParallelProcs,
                                String jobId) {
        final Dictionary<String, Object> props = new Hashtable<String, Object>();
        props.put(WORKFLOW_JOB, this);
//        props.put(EventUtil.PROPERTY_JOB_RETRIES, retryCount);
        if (item.get("workflowModelId") != null) {
            String workflowModelId = (String) item.get("workflowModelId");
            //replace colon, see http://bugs.day.com/bugzilla/show_bug.cgi?id=31340
            workflowModelId = workflowModelId.replace(":", "_");
            props.put(EventUtil.PROPERTY_JOB_TOPIC, JOB_TOPIC + workflowModelId);
        } else {
            props.put(EventUtil.PROPERTY_JOB_TOPIC, JOB_TOPIC);
        }

        props.put(WORKFLOW_JOB_ID, jobId);

        return new Event(EventUtil.TOPIC_JOB, props);
    }
}
