package com.adobe.internal.io;

import java.io.IOException;
import java.io.RandomAccessFile;

/**
 * A {@link com.adobe.internal.io.ByteReader ByteReader} that wraps a
 * {@link java.io.RandomAccessFile RandomAccessFile}. No buffering is provided 
 * so all file access is direct - this is slower than buffering.
 */
public class NonCachedRandomAccessFileByteReader extends ByteReaderWrapperImpl
{
	/**
	 * This class implements a ByteReader in which the bytes are read from
	 * a {@link java.io.RandomAccessFile RandomAccessFile}.
	 * @param file the file to wrap with the ByteReader
	 * @throws IOException 
	 */
	public NonCachedRandomAccessFileByteReader(RandomAccessFile file) 
	throws IOException
    {
		super(new NonCachedRandomAccessFileByteWriter(file));
    }
}
