/* $Header: /Faultline/com/adobe/acrobat/filters/DCTdec_code_struct.java 1     $ */
/*
  DCTdec_code_struct.java

  The various structures used by the JPEG encoder and decoder
  Split into multiple files

  
*/
package com.adobe.internal.pdftoolkit.core.filter;


/* It is convenient to use the DCTDsgetcode and DCTDMakeHuffDec procedures
 for both AC and DC code tables, so the variable length huffval must be the
 last element of huff.dec.  huffbits and huffval must be contiguous for
 DCTDMakeHuffDec, DCTEmake_huffenc, and DCTEgenDHT.  dec.huffbits and
 dec.huffval can overlap the huff.enc struct which is used afterwards; i.e.,
 DCTEmake_huffenc is called with dec.huffbits and dec.huffval as args; it
 calls DCTSizeCodes, but then no longer must preserve the huff.dec arguments.
 With more cleverness, it would be possible to eliminate dec.huffbits and
 dec.nent, which are not used by the decoder after initialization.
 */
class DCTdec_code_struct   /* DC and AC Huffman Decode */
{
    static final int MAX_CODE_LEN       = 16;

    static final int DC_CODE_TBL_SIZE   = 12;

    static final int PROG_AC_HT_SIZE    = 176;
    static final int SEQ_AC_HT_SIZE     = 162;
    static final int AC_CODE_TBL_SIZE   = 176;
    static final int AC_DEC_TBL_NBITS   = 7;
    static final int AC_DEC_TBL_SIZE    = 128;

    int     maxcode[];
    int     biggest;
    int     valptr[];
    int     nent;
    short    huffbits[];
    byte    huffval[];

    /* Constructors */
    DCTdec_code_struct()
    {
        maxcode =   new int[MAX_CODE_LEN];
        valptr =    new int[MAX_CODE_LEN];
    }

    static DCTdec_code_struct newDCdecode()
    {
        return new DCTdec_code_struct();
    }

    static DCTdec_code_struct newACdecode()
    {
        return new DCTdec_code_struct();
    }
}
